---
title: Code Reviews
---
## Code Reviews

Code reviews exist in order to improve the quality of the code in a software project. They are common practice for many software development teams.
Code reviews involve team members looking at each other's code submissions to check for bugs, incorrect logic, and 
potential improvements. A code review can be done amongst developers of the project under review, as well as developers from other teams in the same company.
For those who have not experienced the code review process before, it can be intimidating. However, it is an invaluable process to help you grow as a developer. Even if a review is just an explanation of the code to another programmer,
the feeling that your code is going to be read/inspected by another programmer encourages you to write better code in many ways (e.g. smaller methods, comments, no ["magic numbers"](https://en.wikipedia.org/wiki/Magic_number_(programming))).


Code reviews are also a way for the new-comers in any team to learn about the best practices used by their particular team. If it is entirely a new team, it could also be a way to align all the programmers in the team to follow certain coding practices while writing code.

As to what is reviewed and when, well, there is no clear answer. Many teams have rules that every piece of code that checks-in in the version control system has to be reviewed by another programmer, while other teams have whole days dedicated to code reviews across the team. Teams, within an organization, create internal Coding Standards for the various languages used, as a guidance for developers, and code reviewers. An effective code review is one where functionality, testability, security, and readibility/styling issues are addressed. 

It is important to be humble throughout the code review process. Accept your mistakes and be professional when pointing out improvements or errors in the code of your fellow team members.

#### More Information

* [How to Do Code Reviews Like a Human (Part One)](https://mtlynch.io/human-code-reviews-1/)
* [How to Do Code Reviews Like a Human (Part Two)](https://mtlynch.io/human-code-reviews-2/)
* [Code Review Guidelines](https://blog.philipphauer.de/code-review-guidelines/)
* [Code Review Best Practices](https://medium.com/palantir/code-review-best-practices-19e02780015f)
* [Smartbear - What is Code Review?](https://smartbear.com/learn/code-review/what-is-code-review/)
* [How to Conduct Effective Code Reviews](https://blog.digitalocean.com/how-to-conduct-effective-code-reviews/)
* [Why Code Reviews Matter (and actually save time!](https://www.atlassian.com/agile/software-development/code-reviews)
* [Code Reviews: The Definitive Guide](https://simpleprogrammer.com/code-reviews-definitive-guide/)

