---
title: Dunning-Kruger Effect
---

# Dunning-Kruger (DK) Effect

## Wikipedia's Definition
In the field of psychology, the **Dunning-Kruger** effect is a cognitive bias wherein people of low ability suffer from illusory superiority, mistakenly assessing their cognitive ability as greater than it is. The cognitive bias of illusory superiority derives from the metacognitive inability of low-ability persons to recognize their own ineptitude.

## Why Does it Matter in Software Development?
It is important for software developers to be aware of the DK effect. It can be observed among developers of all ages, and is more prominent among beginners and intermediate-level developers. After the initial struggle, they might get over-confident about a language or their designs. This leads them to underestimate the complexity of system requirements or, worse, hampers them in coming up with better software designs. For more experienced developers, they seem to have gained wisdom over the years. They are more humble and better at judging the system's complexity. (This might not be true for all senior developers, though.)

## Beware!
The DK effect is the exact opposite of [Impostor Syndrome](https://en.wikipedia.org/wiki/Impostor_syndrome). You need to strike the perfect balance between both of these for your professional growth. 

## How to Check if I Suffer from DK Effect?
*You can't!* 

Sorry, but there isn't a straight answer to this question. You can ask yourself the following questions:
 - Am I able to give accurate estimates?
 - Am I open to learning new concepts?
 - Am I open to implementing or trying new design paradigms?
 - Am I humble? 
 - Am I able to take criticism and objectively evaluate feedback?
 - Am I a good listener?

 ## Additional Resources
 - [Wikipedia](https://en.wikipedia.org/wiki/Dunning%E2%80%93Kruger_effect)
