---
title: Imposter Syndrome
---

## Imposter Syndrome

Imposter Syndrome is a feeling of _being a fraud_ or _not being good enough_ to get the job done. It is common among software engineers, developers, and designers working in tech companies, especially those not coming from a traditional tech background.  People suffering from imposter syndrome have a sense of inadequacy and insecurity concerning their ability to make a contribution at the workplace. In reality, they may be perfectly capable and do contribute successfully to their tasks.

Imposter Syndrome is very common among software engineers or developers who are new to the role and lack the experience of some of their co-workers. Throughout various industries, imposter syndrome is very common with highly successful people. Studies have found that two out of five 'successful' people consider themselves frauds/imposters while other studies have shown that up to 70% of people experience imposter syndrome at one point in time or another.

If you suffer from imposter syndrome, you may have a sense of inadequacy or insecurity about your ability to contribute. In reality, you may be perfectly capable and do contribute to your tasks.

These thoughts are fairly common if you struggle with imposter syndrome:

* "What am I doing here?"
* "I am not a developer. I am fooling myself and other people." (feels fake)
* "My colleagues are much smarter than me; I could never match up to them." (undermines own achievements)
* "My coworkers have told me I've achieved a lot, but I feel like it's never enough." (discounts praise)
* "I have no idea how I got through the interview process." (feels only luck dictates results)
* "I will be ridiculed and fired when people realize I am not as smart as I portrayed myself to be." (fears failure)
* "My IQ is not high enough to work here." (doubts inherent ability)
* "I need more training to feel like I deserve to be here."


#### Overcoming Imposter Syndrome

The first step in overcoming imposter syndrome is to learn the difference between a growth mindset and a fixed mindset. People with a growth mindset believe that their skills and talents can be developed through hard work, practice, conversations with others, etc. Alternately, those with a fixed mindset tend to believe their talents are set abilities that they were born with.

When you change your outlook to a growth mindset, you allow yourself to take on challenges that may seem out of reach. If you believe that your skills can be developed over time, it will matter less if you don't know how to do something (as long as you are willing to put in the work). In fact, the only true way to continually develop your skills is to be pushed beyond your limits each day and be challenged. Therefore, try to think of imposter syndrome feeling as a good indication that you are becoming better each day.

[Many talented, successful people deal with Imposter Syndrome](https://www.thecut.com/2017/01/25-famous-women-on-impostor-syndrome-and-self-doubt.html). They even say that - counterintuitively - not only does success not eliminate Imposter Syndrome; many times, success makes it worse. So, it isn't something we conquer once. We conquer it every day, every time we take on a project, task, etc.

Imposter Syndrome may prevent you from reaching out when you need help, thus slowing your progression. Please do reach out on the forum or the chatroom!
More great resources to help you know more about Imposter Syndrome and some tips to tackle it:

* [American Psychological Association - Feel Like a Fraud?](http://www.apa.org/gradpsych/2013/11/fraud.aspx)
* [TED Talks - Fighting Imposter Syndrome](https://www.ted.com/playlists/503/fighting_impostor_syndrome)
* [Quartz - Is imposter syndrome a sign of greatness?](https://qz.com/606727/is-imposter-syndrome-a-sign-of-greatness/)
* [HTTP203 - Imposter Syndrome](https://www.youtube.com/watch?v=VNr1Kb07aME)
* [Ada Initiative - Is Impostor Syndrome keeping women out of open technology and culture?](https://adainitiative.org/2013/08/28/is-impostor-syndrome-keeping-women-out-of-open-technology-and-culture/)
* [DEV - Overcoming Impostor Syndrome](https://dev.to/kathryngrayson/overcoming-impostor-syndrome-apg)
* [FastCompany - Types of imposter syndrome and how to beat them](https://www.fastcompany.com/40421352/the-five-types-of-impostor-syndrome-and-how-to-beat-them)
* [Startup Bros - 21 Proven Ways to Overcome Imposter Syndrome](https://startupbros.com/21-ways-overcome-impostor-syndrome/)
* [NY Times - Learning How to Deal with the Imposter Syndrome](https://www.nytimes.com/2015/10/26/your-money/learning-to-deal-with-the-impostor-syndrome.html)
* [Medium - 3 Ways to Outsmart Imposter Syndrome](https://medium.com/the-mission/3-ways-to-outsmart-imposter-syndrome-400aa3baa5c3)
* [The Every Girl - 5 Books to Read If You're Struggling With Imposter Syndrome](http://theeverygirl.com/5-books-read-youre-struggling-imposter-syndrome/)
* [Wikipedia - Imposter Syndrome](https://en.wikipedia.org/wiki/Impostor_syndrome)

