---
title: Working in Tech & Information Technology(IT)
---

## Working in Tech and IT
A wide variety of technology-related fields such as web development, design, data science, infrastructure support, information security, and product management are often lumped into the catch-all term "Tech" or IT. 

## Underrepresented People in Tech
This section will focus on additional career challenges faced by underrepresented minorities and people from non-traditional education backgrounds. Specific topics will include sexism and ageism, which have been particularly prevalent in certain industries and organizations.

### Working with recruiters
Persons of color or females or disadvantaged workers may find it necessary to utilize recruiters in IT. It is important to develop a relationship with recruiters who may be more successful getting you an interview. Recruiters can sell your skills as they often have direct relationships with the hiring managers. This is the equivalent of having a friend recommend you. Also, before beginning your job search, clean up all social media and mute those friends who make inappropriate posts. Your posts should be positive and be sprinkled with samples of your work or projects.

## Computer Security
The field of computer security is growing at a rapid rate every year.  As more people continue to store information electronically, the need for individuals to protect that information will increase proportionally. If these roles continue to be filled at the current rate, a recent study has estimated that this critical field will have a job shortage of 3.5 million people by 2021. 

## Examples of Tech-Related jobs
- Software Developer
- Data Engineer
- Computer Systems Analyst
- Web Developer
  - Front-end developer
  - Back-end developer
- Software Engineer
- IT Manager
- Computer Systems Administrator
- Network Administrator
- Support Desk Engineer
- Security Engineer
- Project Manager
- Ethical hackers
- Data Scientist
- Software Tester
- Infrastructure Support
- Help Desk Analyst
- Data Analyst
- Data Scientist
- Database Manager
- Mobile app Developer (Android and IOS)

## Additional Resources

### Books
- [About Face: The Essentials of Interaction Design](https://www.amazon.com/About-Face-Essentials-Interaction-Design-dp-1118766571/dp/1118766571/)
- [Thinking in Systems: A Primer](https://www.amazon.com/gp/product/1603580557/)
- [Thinking, Fast and Slow](https://www.amazon.com/gp/product/0374533555/)
- [How to Win Friends & Influence People](https://www.amazon.com/How-Win-Friends-Influence-People/dp/0671027034/)
- [Learn You a Haskell for Great Good!](https://amzn.to/2veOjdv)
- [Think Like a Programmer](https://www.nostarch.com/thinklikeaprogrammer)
- ["Lean In: Women, Work, and the Will to Lead" by Sheryl Sandberg](https://www.amazon.com/Lean-Women-Work-Will-Lead/dp/0385349947/)
- [The Mythical Man-Month: Essays on Software Engineering](https://www.amazon.com/Mythical-Man-Month-Software-Engineering-Anniversary/dp/0201835959)
- [The Pragmatic Programmer: From Journeyman to Master](https://www.amazon.com/Pragmatic-Programmer-Journeyman-Master/dp/020161622X)
- [Clean Code: A Handbook of Agile Software Craftsmanship](https://www.amazon.com/Clean-Code-Handbook-Software-Craftsmanship/dp/0132350882/)
- [Design Patterns: Elements of Reusable Object-Oriented Software](https://www.amazon.com/Design-Patterns-Elements-Reusable-Object-Oriented-ebook/dp/B000SEIBB8)
- [Cracking the Coding Interview: 189 Programming Questions and Solutions](https://www.amazon.com/Cracking-Coding-Interview-Programming-Questions/dp/0984782850/)
- [Introduction to Algorithms](https://www.amazon.com/Introduction-Algorithms-3rd-MIT-Press/dp/0262033844)
- [Hooked: How to Build Habit-Forming Products](https://www.amazon.com/Hooked-How-Build-Habit-Forming-Products/dp/1591847788/)
- [Ethical Hacking and Penetration Testing Guide](https://www.amazon.in/Ethical-Hacking-Penetration-Testing-Guide/dp/1482231611)

### Articles
- [We fired our top talent. Best decision we ever made.](https://medium.freecodecamp.org/we-fired-our-top-talent-best-decision-we-ever-made-4c0a99728fde)
- [You fired your top talent. I hope you’re happy.](https://medium.com/@deusexmachina667/you-fired-your-top-talent-i-hope-youre-happy-cf57c41183dd)
- [How to run a successful development process (even if you’re not technical)](https://medium.freecodecamp.org/how-to-run-a-successful-development-process-even-if-youre-not-technical-185d0558c89a)
- [What is technical debt? And why does almost every startup have it?](https://medium.freecodecamp.org/what-is-technical-debt-and-why-do-most-startups-have-it-9a54458daabf)
- [How you can land a 6-figure job in tech with no connections — tips that got me job offers from Google and other tech giants](https://medium.freecodecamp.org/how-you-can-land-a-6-figure-job-in-tech-with-no-connections-6eed0de26ea4)
- [The Complete Software Developer's Career Guide](https://simpleprogrammer.com/products/careerguide/)

### Podcasts
- [10 Books Python Developers should be reading - talkpython.fm](https://talkpython.fm/episodes/show/130/10-books-python-developers-should-be-reading)
- [CodeNewbie](https://www.codenewbie.org/)
- [This week in Google](https://twit.tv/shows/this-week-in-google)
- [Programming Throwdown - Good overview of multiple languages and concepts](https://www.programmingthrowdown.com/)
- [Shop Talk: A Web Design and Development Podcast](https://shoptalkshow.com/)
- [Command Line Heroes - Red Hat](https://www.redhat.com/en/command-line-heroes)
- [Learn to Code With Me - Laurence Bradford](https://learntocodewith.me/podcast/)
- [WorkingTech: Talent, Tech, and Innovation](http://workingtech.co/podcast/)

