---
title: Open Source
---
![Open Source Logo](https://opensource.org/files/osi_logo_100X133_90ppi_0.png)
## Open Source

Open source software is any type of software that is available to the public to use, modify, or download for free. Anyone is capable of creating an open source project.

Open source projects are legally made open through a creative license. They are changed, maintained, or abandoned by their creators at any time. Many open source projects have contributors that volunteer to add and edit code, and a growing number of open source projects are taking a major place among the most popular software available today.

### Advantages
Open source is not dependent on the company or author that originally created it. In a situation in which the company fails, the code continues to exist and the users will keep developing it. Also, it uses open standards accessible to everyone; thus, it does not have the problem of incompatible formats that exist in proprietary software.

Also, the companies using open-source software do not have to think about complex licensing models and do not need anti-piracy measures like a product activation or serial number.

Open source software is typically of **lower cost**, **higher security** and **better quality** when compared to proprietary software.

### Disadvantages
The main disadvantage of open-source software is that often it is not very straightforward to use. Open source operating systems like Linux cannot be learned in a day. They require continuous effort and training from your side before you are able to master them. You may need to hire a trained person to make things easier, and this may incur additional costs.

### Open source for developers
Open source software allows developers to view the source code of any software which is under creative license. Open source projects make it easier for developers to contribute to different projects without even making changes in the actual file on the server by just downloading the file on our local machine.

There are different websites where people can find open source projects, such as:
- [GitHub](https://github.com/explore)
- [Google Open Source](https://opensource.google.com/)
- [Mozilla Projects](https://developer.mozilla.org/en-US/docs/Mozilla/Mozilla_on_GitHub)
- [CodeTriage](https://www.codetriage.com/)

One of the biggest Open Source projects is Linux.

#### More Information:

- [Open Source Initiative](https://opensource.org/), 
- [Wikipedia Open Source Model](https://en.wikipedia.org/wiki/Open-source_model), 
- [Wikipedia Open Source Software](https://en.wikipedia.org/wiki/Open-source_software), 
- [The Mozilla Foundation](https://www.mozilla.org/en-CA/foundation/)
