---
title: Racial Diversity in Tech
---
## Racial Diversity in Tech

In addition to issues with gender diversity and other kinds of bias (such as ableism) in tech fields, referred to hereafter using the STEM acronym (Science, Technology, Engineering, and Mathematics), racial diversity is a significant problem, especially in the USA. As these charts from [datausa.io](datausa.io) help show, the vast majority of software developers and computer programmers in the US and around the world are white, in ways that are not representative of the general population.
<iframe width="720px" height="480px" src="https://embed.datausa.io/profile/soc/151131/demographics/ethnicity?viz=True" frameborder="0"></iframe>
<iframe width="720px" height="480px" src="https://embed.datausa.io/profile/soc/15113X/demographics/ethnicity?viz=True" frameborder="0"></iframe>

## Why is Racial Diversity Important in STEM?

Beyond the simple ethics of fairness and equal opportunities for all, there are many core business reasons that drive a need for diversity.

#### Better Decision Making:

Cloverpop did [an extensive research study](https://www.forbes.com/sites/eriklarson/2017/09/21/new-research-diversity-inclusion-better-decision-making-at-work/#f7050524cbfa) including 600 major decisions made by 200 different teams and found the following:

* Inclusive teams make better business decisions up to 87% of the time.
* Teams that follow an inclusive process make decisions 2X faster with 1/2 the meetings.
* Decisions made and executed by diverse teams delivered 60% better results.

#### Better Performance:

Another [MIT Study](http://news.mit.edu/2014/workplace-diversity-can-help-bottom-line-1007) found that diverse teams consistently outperform homogenous teams, as much as 41 percent.

## Pew Research Findings for Diversity Now

The Pew Research Center released a report in January 2018 with key findings for those who seek to address issues of racial diversity in STEM. A few issues they point out are:

* Most Americans agree that workplace diversity is important, but African Americans place the most emphasis of any group.
* The leading reason tech workers believe there to be inequality is unequal access to quality education for blacks and Hispanics.
* Almost 2/3 of African Americans in STEM report having experienced workplace discrimination. The most common source of discrimination listed was their treatment by their coworkers.
* The hiring process itself is considered by most groups to be fair and non-discriminatory.

### More Information:
* [Pew Research 2018 Report on Racial Diversity in Tech](http://www.pewsocialtrends.org/2018/01/09/blacks-in-stem-jobs-are-especially-concerned-about-diversity-and-discrimination-in-the-workplace/)
* [The Verge 2015 Data on Diversity in Tech Giants](https://www.theverge.com/2015/8/20/9179853/tech-diversity-scorecard-apple-google-microsoft-facebook-intel-twitter-amazon)
* [US Equal Employment Opportunity Commission 2014 Data](https://www.eeoc.gov/eeoc/statistics/reports/hightech/)
* [Google 2016 Report on Diversity Gaps in Computer Science, with special emphasis on women, blacks, and Hispanics](https://services.google.com/fh/files/misc/diversity-gaps-in-computer-science-report.pdf)

### A non-exhaustive list of global racial diversity in tech initiatives:
* [**Black Girls Code**, with Chapters in Boston, Chicago, DC, New York, Detroit, Atlanta, Houston, Dallas, Memphis, and Raleigh-Durham](http://www.blackgirlscode.com/)
* [**Blacks in Technology**, with Chapters in Cincinnati, Chicago, Houston, San Diego, Twin Cities (St. Paul/Minneapolis), Washington D.C., Los Angeles, RTP (Research Triangle Park, N.C.) ](https://www.blacksintechnology.net/)
* [**Code 2040** in San Francisco](http://www.code2040.org/)
