---
title: Remote Versus Onsite
---
## Remote Versus Onsite

There are two main work environments: onsite and remote. And there are pros and cons to both. 

### Onsite Work

Onsite work is what you might think of when you think of a 9-5 job. When you're onsite, you may either be in your company's office or at a client's office. Either way, you're in the same physical location as the rest of the people with whom you work. 

#### Pros of Onsite Work
* ability to interact face-to-face (good for collaboration and morale)
* access to facilities and peers
* improves bond of coworkers

#### Cons of Onsite Work
* potential for distraction/excessive socializing
* subject to company culture
* commuting

### Remote Work

Remote work occurs when team members work in separate physical locations. You can work from anywhere: your home (no commute!), a co-working space (sometimes paid for by your employer), or even a beach in Thailand. Often your only restriction is that you have internet access. Sometimes you will also see this listed as a "distributed team" or "100% remote", with emphasis on the 100%. 

Because in-person communication occurs less frequently (if at all), remote teams often rely more on communication software like [Slack](https://slack.com/), [Skype](https://www.skype.com/), and [HipChat](https://www.hipchat.com/), and collaboration software like [Trello](https://trello.com/) and [Jira](https://www.atlassian.com/software/jira).

Remote teams may host regular company retreats so team members can meet, hang out and plan the next steps for their company.

Most companies that are fully remote or have a significant number of remote workers are small in size.

Because in-person communication occurs less frequently (if at all), remote teams often rely more on communication software like [Slack](https://slack.com/) and [Skype](https://www.skype.com/).

#### Pros of Remote Work
* cutting down commute time and costs
* flexibility
* expand geographic limitations by hiring outside of local area

#### Cons of Remote Work
* weakens communication
* without frequent 'face time', may lower employee morale
* potential for decreased efficiency and productivity

### Benefits of Working Remotely

Some of the benefits of working remotely include location independence, a more flexible schedule, better control over your daily schedule, no commuting, and personal accomodation for special needs. Keep in mind that every company has its own guidelines and limits around hours, location, and availability.

### Disadvantages of Remote Work

Depending on your personality and your employment situation, there can be disadvantages. For example, some people are not well-suited to a full week of solo work. They prefer the face to face and other social contact that comes with working in an office. In some larger companies people can feel left out of the mainstream or passed over for work opportuinities. Other people feel pressured to participate in every stream of daily communication and this can impact your ability to work effectively. Be sure to know what your personal preferences are before deciding to be a remote worker.

### The "In-Between"
Some companies are 100% onsite, and some are 100% remote. But, it's not unusual to find companies or teams that allow you to work remotely a day or two out of the week. This allows you to experience some of the benefits of remote work, without being remote all the time. You will also find that there are significant numbers of remote workers in larger companies. Some positions need to be supported from areas where no physical office exists or the role may require a significant amount of travel so location is not important.

Remote work can be a great tool for a business as a contingency plan in the event of inclement weather or a natural disaster.

Some companies also have a physical office where you can go to work if you'd like, but allow you to work wherever. Recently there has been more movement from large companies, such as IBM, toward moving employees back to onsite employment. However, many large organizations are still very flexible and willing to let you work from home, or another convenient location.

With teams that are not 100% remote (some onsite and some remote) this can sometimes create a disconnect between those working in the office and those working from home. For example, communication needs to be top priority to make sure no one is left out of an impromptu meeting or decision. 

### Multiple Teams 

Larger companies may have a different version of the "in-between", where they have a number of different teams working  onsite, but in multiple different locations. For example, a team working onsite in New York and another team working onsite in Chicago. You can hang out with other team members in an office, but you also use remote working techniques (Slack, Skype, etc) to stay in contact and in sync with the other teams. The teams may all be working on the same project, or developing something independently against the same application or platform.

### More Information:

[Economics of Working Remotely](https://medium.freecodecamp.org/the-economics-of-working-remotely-28d4173e16e2)

[Advantages of Working On-site](https://www.itechus.com/2017/09/12/the-advantages-of-working-onsite-for-it-staff/)

[Pros and Cons of a Distributed Workforce](https://www.forbes.com/sites/forbestechcouncil/2017/08/03/13-pros-and-cons-of-having-a-distributed-workforce/#155dc27013d9)

