---
title: Unconscious Bias
---

## Unconscious Bias

Bias is a prejudice in favor of or against one thing, person, or group compared with another, usually in a way that’s considered to be unfair. Biases may be held by an individual, group, or institution and can have negative or positive consequences. For that reason, the benefits of prejudice can only exist at the expense of others. Therefore to be "biased for" something, you must be "biased against" something else.

Unconscious bias, otherwise known as "implicit bias", occurs when people favour others who look like them and/or share their values. For example a person may be drawn to someone with a similar educational background, from the same area, who shares a similar sexual orientation, or who is the same colour or ethnicity as them.

Implicit or unconscious bias happens when our brains make incredibly quick judgments and assessments of people and situations without us realizing. Our biases are influenced by our background, cultural environment, and personal experiences. We may not even be aware of these views and opinions, or be aware of their full impact and implications.<sup>3</sup>

Unconscious bias is far more prevalent than conscious prejudice and is often incompatible with one’s conscious values. Certain scenarios can activate unconscious attitudes and beliefs. For example, biases may be more prevalent when multi-tasking or working under time pressure.<sup>4</sup>

If you are working in a [hybrid remote team](https://github.com/freeCodeCamp/guides/src/pages/working-in-tech/remote-versus-onsite/index.md), there may be an unconscious bias at play depending on where someone sits. For example, people hang out with colleagues physically (the literal 'water cooler' moment) in a different way to how they do via Slack. Strong teams and leaders are aware of this and choose to [follow certain protocols](https://viewpoints.matrixpartners.com/how-to-support-remote-work-by-removing-unconscious-bias-7a974f953410) work to minimize its effects.

### Project Implicit:

There are many factors that can give you an unconscious bias, such as:

- Our Perception – how we see people and perceive reality.
- Our Attitude – how we react towards certain people.
- Our Behaviours – how receptive/friendly we are towards certain people.
- Our Attention – which aspects of a person we pay most attention to.
- Our Listening Skills – how much we actively listen to what certain people say.
- Our Micro-Affirmations – how much or how little we comfort certain people in certain situations.

It was also found in various studies that even the order of questions in a test can lead to unconscious bias. There is a very good video on the topic [here](https://www.youtube.com/watch?v=75g4d5sF3xI").  
  
Unconscious bias can influence decisions in recruitment, promotion, and performance management. It could be discriminatory when the unconscious bias relates to a protected characteristic.  

#### More Information:
1. [Navarro, Renee MD. "What is unconscious bias?" *University of California, San Francisco.* Accessed: October 20, 2017](https://diversity.ucsf.edu/resources/unconscious-bias)
2. ["Unconscious Bias." *Advisory, Conciliation and Arbitration Service.* Accessed: October 20, 2017](http://www.acas.org.uk/index.aspx?articleid=5433)
3. ["Unconscious Bias." *Equality Challenge Unit.* Accessed: October 20, 2017](https://www.ecu.ac.uk/guidance-resources/employment-and-careers/staff-recruitment/unconscious-bias/)
4. ["Understanding unconcious bias" Royalsociety.org Accessed: October 19, 2018.](https://royalsociety.org/topics-policy/publications/2015/unconscious-bias/)
5. ["Unconscious Bias" ecu.ac.uk Accessed: October 2018.](https://www.ecu.ac.uk/)
6. ["5 Common Unconscious Biases That Lead To Bad Decisions" FastCompany Accessed: October 18th, 2018](https://www.fastcompany.com/3045035/5-common-unconscious-biases-that-lead-to-bad-decisions)
