---
title: Women in Tech
---

## Women In Tech

From an article on ["The Latest Stats on Women in Tech"](https://www.themuse.com/advice/the-latest-stats-on-women-in-tech):

> "We all know that there's a major gender gap when it comes to women in tech. 
>
> Although we make up the majority of the workplace and the social media sphere, we only represent a tiny percentage of the technology world.
>
> And that's reflected in some of the stats you see. According to a 2011 report from the Level Playing Field Institute, 82% of men in startups believed their companies spent the 'right amount of time' addressing diversity, while almost 40% of women believed not enough time was devoted.”

This is especially true in discussions about intersectionality. According to an article MarketWatch, today, while women hold about 19% of computing degrees, women of color hold about 4%. Even more concerning is that over the past decade, the percentage of Black, Latina, and Native American women fell by almost 40%.

![Alt text](https://www.womenwhotech.com/wp-content/uploads/infographic_700_FINAL.png "Women in Tech")

Although women are still underrepresented in the tech world, it does not mean that we are not making a difference there.

In a Women in Tech Round-up event presented by Google in Austin, the women who spoke at this event were vice presidents (VPs) and high-level management positions from profitable companies working in the tech industry. Not all of them began their careers in the tech world, many had started as secretaries and other roles that are often populated by women. They worked hard and took risks to get where they are now. The one piece of advice that seemed to resound from all of them was that for you to succeed, you must take risks. 

The worst thing you can do is to sell yourself short if you want something take that risk and achieve the impossible. 

The Google VP who spoke at this event gave the audience a piece of advice: women should take any and every opportunity afforded to them and risk applying to jobs they are not qualified for. The worst that will happen is they will get rejected or you won’t get an interview. Men frequently get tech positions not because they are more experienced or better than women, but because they apply to positions that they often aren’t qualified for. Conversely, women tend to apply only for jobs that they think they are qualified for. Various studies show that women applied only to jobs where they fully match the desired criteria, compared to men, who applied to positions which were about 50% match.

**"Do not think for one minute that because you are who you are, you cannot be who you imagine yourself to be."**    
*-Jedidah Isler in her TED talk - [The Untapped Genius That Could Change Science for the Better](https://www.youtube.com/watch?v=3NdSVi38RM8)*    

The worst thing you can do is to sell yourself short. If you want something, take that risk and achieve the impossible.

Encouraging girls in elementary, middle, and high school can also help to increase the number of women going to work in the tech industry as they get older. We must actively fight against gender stereotypes in careers beginning at a young age so that children fully understand what career options are available to them. If girls are able to get more familiar with computer science concepts at a young age, this will help to make entering a college classroom full of men a less intimidating experience. Over time we will hopefully start to see a gender balance in tech careers. 

Additionally, there are a variety tech of women in  groups that you can join no matter where you are in the world. Facebook groups such as [Ladies Storm Hackathons](https://www.facebook.com/groups/LadiesStormHackathons/) and [Women Who Reign: Advancing Women in STEM](https://www.facebook.com/groups/ReigningIt/) offer incredible support for women in tech from women in tech. Members offer advice, post useful links, and opportunities all the time! These groups are definitely great communities to join.

## More Information:
- [Why are there so few women in tech? The truth behind the Google memo](https://www.theguardian.com/lifeandstyle/2017/aug/08/why-are-there-so-few-women-in-tech-the-truth-behind-the-google-memo)
- [Ellen Pao: Has Anything Really Changed for Women in Tech?](https://www.nytimes.com/2017/09/16/opinion/sunday/ellen-pao-sexism-tech.html)
- [It's Time to Close the Gap for Women of Color in Tech](https://www.marketwatch.com/press-release/its-time-to-close-the-gap-for-women-of-color-in-tech-2018-09-13)
- [We need more women in tech in order to get more women in tech](https://www.recode.net/2018/6/21/17489450/tech-diversity-inclusion-women-leadership-engineer-culture)
- [Ada Lovelace: the first Computer Programmer](https://en.wikipedia.org/wiki/Ada_Lovelace)
- [Women in Tech 2018: What the Statistics Tell Us](https://www.technative.io/women-in-tech-2018-what-the-statistics-tell-us/)
- [Closing the gender gap in tech—it’s time to act](https://www.linkedin.com/pulse/closing-gender-gap-techits-time-act-melinda-gates/)

### Some Popular Conferences and Summits for Women in Technology:
- [GHC Women in Computing](https://ghc.anitab.org/)
- [The Women in Tech Summit](https://womenintechsummit.net/)
- [Wonder Women Tech National Conference](https://wonderwomentech.com/)
- [WITI Women in Technology Summit](https://www.witi.com/conferences/2018/summit/)

### A non-exhaustive list of global women in tech initiatives:
- [ChickTech](https://chicktech.org/)
- [PyLadies](https://www.pyladies.com/)
  An international mentorship group with a focus on helping more women become active participants and leaders in the Python open-source community.
- [R-Ladies](https://rladies.org/)
  A worldwide organization whose mission is to promote gender diversity in the R Community by encouraging, inspiring, and empowering people of genders currently underrepresented in the R community.
- [Django Girls](https://djangogirls.org/)
  A non-profit organization and a community that empowers and helps women to organize free, one-day programming workshops by providing tools, resources and support.
- [Rails Girls](http://railsgirls.com/)
  A global, non-profit volunteer community whose aim is to give tools and a community for women to understand technology and to build their ideas. Hosts Ruby-on-Rails-specific coding workshops for girls. 
- [Girls Who Code](https://girlswhocode.com/)
  Girls Who Code is a nonprofit organization which aims to support and increase the number of women in computer science. 
- [1 Million Women To Tech](https://1millionwomentotech.com/)
  A 501(c)3 educational non-profit whose mission is to offer free coding education to 1 million women by 2020. 
- [Women Who Code](https://www.womenwhocode.com)
  Women Who Code is an global non-profit with a set of programs for engineers to reach the careers we want. 
- [MotherCoders](http://www.mothercoders.org)
  MotherCoders offers an eight-week tech camp focusing on helping mothers enter tech careers.
- [Ada Developers Academy](https://adadevelopersacademy.org/)
  Ada is a free females-only developer academy lasting 11 months based in Seattle, WA. 
- [Women Techmakers](https://www.womentechmakers.com/)  
- [We Can {Code} It]{https://wecancodeit.org/)

### Podcasts on Women-in-tech:
If you're interested in podcasts, check out Esperee Devora's on women in tech [here](http://podcast.womenintechshow.com/episodes).
