---
title: Accessibility Examples
localeTitle: Примеры доступности
---
## Примеры доступности в практическом применении

Я пишу это краткое руководство, чтобы представить практические примеры того, как реализовать доступность на веб-сайтах. Доступность не была подчеркнута во время учебы, и ее недостаточно подчеркивали в реальном мире веб-разработки. Я надеюсь, что эта статья, как и многие другие, побудит разработчиков создавать доступные сайты с этого момента. Это всегда помогло мне получить практические советы о том, как делать вещи. Таким образом, это руководство будет посвящено примерам реального мира, с которыми я столкнулся в повседневной жизни как веб-разработчик.

### Пропуск навигации


Чтобы дать слепым посетителям приятный опыт посещения вашего сайта, они должны иметь возможность быстро и эффективно получать информацию. Если вы никогда не посещали веб-сайт с помощью программы чтения с экрана, я рекомендую это сделать. Это лучший способ проверить, насколько легко организована навигация по сайту для незрячих пользователей. NVDA - очень хорошее приложение для чтения с экрана, которое предоставляется бесплатно. Но если вы используете программу чтения с экрана и считаете ее полезной, подумайте о том, чтобы сделать пожертвование команде разработчиков. Считыватель экрана можно загрузить с [сайта nvaccess.org](https://www.nvaccess.org/download/) .


Чтобы позволить незрячим пользователям пропустить основное содержимое сайта и избежать табуляции по всем основным ссылкам навигации:

1.  Создайте «пропустить навигационную ссылку», которая находится непосредственно под тегом открытия `body` .

```html

<a tabindex="0" class="skip-link" href="#main-content">Skip to Main Content</a> 
```

`tabindex="0"` добавлен, чтобы обеспечить связь с клавиатурой на всех браузерах. Дополнительную информацию о доступности клавиатуры можно найти на [webaim.org](https://webaim.org/techniques/keyboard/tabindex) .

2.  Ссылка «пропустить навигацию» должна быть связана с основным тегом html в вашем документе веб-страницы с использованием тега ID.

```html

<main id="main-content"> 
  ...page content 
 </main> 
```

3.  Скрыть ссылку «пропустить навигацию» по умолчанию. Это гарантирует, что ссылка будет видна только наблюдаемым пользователям, когда ссылка находится в фокусе.

*   Создайте класс для ссылки, которая может быть написана с помощью CSS. В моем примере я добавил `skip-link` класс.

```css
.skip-link { 
  position: absolute; 
  width: 1px; 
  height: 1px; 
  padding: 0; 
  overflow: hidden; 
  clip: rect(0, 0, 0, 0); 
  white-space: nowrap; 
  -webkit-clip-path: inset(50%); 
  clip-path: inset(50%); 
  border: 0; 
 } 
 .skip-link:active, .skip-link:focus { 
  position: static; 
  width: auto; 
  height: auto; 
  overflow: visible; 
  clip: auto; 
  white-space: normal; 
  -webkit-clip-path: none; 
  clip-path: none; 
 } 
```

Эти стили CSS скрывают ссылку по умолчанию и отображают только ссылку, когда она получает фокус клавиатуры. Для получения дополнительной информации посетите [a11yproject](http://a11yproject.com/posts/how-to-hide-content) и этот [пост в блоге](http://hugogiraudel.com/2016/10/13/css-hide-and-seek/) .

### Доступные таблицы

### Доступные вкладки
