---
title: Accessibility
localeTitle: доступность
---
## доступность

**Доступность в Интернете означает, что люди с ограниченными возможностями могут пользоваться Интернетом** .
В широком смысле, когда мы говорим, что сайт доступен, мы имеем ввиду, что контент сайта доступен и его функционалом может воспользоваться буквально кто угодно.

Доступность относится к пользователям, которые могут выходить за рамки узкого понятия "типичный" пользователь, к пользователяим, которые могут иметь доступ или взаимодействовать с вещами не так, как вы ожидаете. В частности, это касается пользователей, у которых имеются некоторые нарушения или инвалидность — и имейте в виду, что это всё может быть нефизическим или временным.
Более конкретно, доступность в Интернете означает, что люди с ограниченными возможностями могут воспринимать, понимать, перемещаться и взаимодействовать с Интернетом и что они могут вносить вклад в Интернет. Доступность в Интернете также приносит пользу другим, включая [пожилых людей](https://www.w3.org/WAI/bcase/soc.html#of) с изменяющимися способностями из-за старения.

Xотя мы и склонны сосредотачивать наше обсуждение доступности на пользователях с физическими нарушениями, всем нам знаком опыт использования интерфейса недоступного для нас по другим причинам. У вас когда-нибудь были проблемы с использованием сайта на мобильном телефоне, или вы видели сообщение "Этот контент недоступен в вашем регионе", или вы не могли найти знакомое меню на планшете? Все это проблемы доступности.

Как станет ясно в дальнейшем, когда вы решаете проблемы доступности в этом, более широком, более глобальном смысле, это почти всегда улучшает пользовательский опыт для всех.

Доступность в Интернете включает в себя все ограничения, влияющие на доступ к Интернету, включая визуальные, слуховые, физические, речевые, когнитивные и неврологические инвалиды. Документ « [Как люди с ограниченными возможностями используют Интернет»](http://www.w3.org/WAI/intro/people-use-web/Overview.html) описывает, как различные инвалиды влияют на использование в Интернете и включают в себя сценарии людей с ограниченными возможностями с использованием Интернета.

Доступность в Интернете также **приносит пользу** людям _без_ инвалидности. Например, ключевым принципом доступности Интернета является создание веб-сайтов и программного обеспечения которые являются гибкими для удовлетворения различных потребностей пользователей, предпочтений и ситуаций. Эта **гибкость** также приносит пользу людям _без_ ситуации, такие как люди, использующие медленное подключение к Интернету, люди с «временными ограничениями», такими как сломанная рука, и люди с изменяющимися способностями из-за старения. В документе « [Разработка бизнес-кейса для веб-доступности для вашей организации»](https://www.w3.org/WAI/bcase/Overview) описаны многие различные преимущества доступности Интернета, включая **преимущества для организаций** .

Доступность в Интернете также должна включать людей, которые не имеют доступа к Интернету или компьютерам.

Значительное руководство для веб-разработки было представлено [Консорциумом Всемирной паутины (W3C)](https://www.w3.org/) , [Инициативой по доступности веб-сайтов](https://www.w3.org/WAI/) из которого мы получаем [WAI-ARIA](https://developer.mozilla.org/en-US/docs/Learn/Accessibility/WAI-ARIA_basics) , доступный богатый пакет интернет-приложений. Где WAI решает семантику html, чтобы легче называть DOM Tree, ARIA пытается сделать веб-приложения, особенно те, которые разработаны с помощью javascript и AJAX, более доступный.

Использование изображений и графики на веб-сайтах может снизить доступность для лиц с нарушениями зрения. Однако это не означает, что дизайнеры должны избегать используя эти визуальные элементы. При правильном использовании визуальные элементы могут сообщать пользователям о том, что они выглядят невооруженным глазом, и их следует использовать для этого. Чтобы правильно использовать эти элементы, веб-дизайнеры должны использовать текст alt для передачи сообщения этих элементов тем, кто не может видеть их. Текст Alt должен быть коротким и точным - как правило, [не более 5-15 слов](https://www.thoughtco.com/writing-great-alt-text-3466185) . Если графический используется для передачи информации, которая превышает ограничения текста alt, эта информация также должна существовать в виде веб-текста, чтобы читать по экрану читатели. [Подробнее об альт-тексте](https://webaim.org/techniques/alttext/) ...

Точно так же, как текст Alt предназначен для людей с ослабленным зрением, транскрипты аудио предназначены для людей, которые не могут слушать. Предоставление письменного документа или стенограммы того, что говорят, доступным людям, которые плохо слышат.

Copyright © 2005 [World Wide Web Consortium](http://www.w3.org) , ( [MIT](http://www.csail.mit.edu/) , [ERCIM](http://www.ercim.org) , [Keio](http://www.keio.ac.jp) , [Beihang](http://ev.buaa.edu.cn) ). http://www.w3.org/Consortium/Legal/2015/doc-license

### Дополнительная информация:

[w3.org введение в доступность.](https://www.w3.org/WAI/intro/accessibility.php) [Проект A11Y](http://a11yproject.com/)
Доступность (https://developers.google.com/web/fundamentals/accessibility/?hl=ru)
