---
title: Acceptance Testing
localeTitle: Приемочное тестирование
---
## Приемочное тестирование

Приемочное тестирование, метод тестирования, выполняемый для определения того, соответствует ли система программного обеспечения спецификациям требований. Основная цель этого теста - оценить соответствие системы бизнес-требованиям и проверить, соответствует ли она необходимым критериям для доставки конечным пользователям.

Существуют различные формы приемочного тестирования:

\->1.   Приемочное тестирование пользователей

\->2.   Приемочное тестирование

\->3.   Альфа-тестирование

\->4.   Бета-тестирование

# Критерии приема

Критерии приемлемости определяются на основе следующих атрибутов:

\-> Функциональная корректность и полнота

\-> Целостность данных

\-> Преобразование данных

\-> Используемость

\-> Производительность

\-> Своевременность

\-> Конфиденциальность и доступность

\-> Устанавливаемость и повышаемость

\-> Масштабируемость

\-> Документация

# План тестирования приемки - Атрибуты

Приемочные испытания проводятся поэтапно. Во-первых, основные тесты выполняются, и если результаты теста удовлетворительны, выполняется выполнение более сложных сценариев.

План тестирования приемки имеет следующие атрибуты:

\-> Введение

\-> Приемочные испытания

\-> Операционная среда

\-> Идентификатор тестового примера

\-> Название теста

\-> Целевая задача

\-> Процедура тестирования

\-> Расписание испытаний

\-> Ресурсы

Деятельность по приемочным испытаниям предназначена для достижения одного из выводов:

\-> Принять систему как поставленную

\-> Принять систему после того, как были сделаны требуемые изменения

\-> Не принимайте систему

# Отчет о приемочных испытаниях - атрибуты

Отчет о приемочных испытаниях имеет следующие атрибуты:

\-> Идентификатор отчета

\-> Резюме результатов

\-> Вариации

\-> Рекомендации

\-> Резюме списка To-DO

# \-> Решение о принятии решения

Приемочное тестирование фокусируется на проверке того, соответствует ли разработанное программное обеспечение всем требованиям. Его основная цель - проверить, соответствует ли разработанное решение ожиданиям пользователей.

Приемочное тестирование - это хорошо зарекомендовавшая себя практика разработки программного обеспечения. Приемочное тестирование является важной частью функционального тестирования вашего кода.

Приемочный тест проверяет, что код работает как ожидалось, т.е. дает ожидаемый результат, учитывая ожидаемые входы.

Приемочный тест используется для тестирования относительно больших функциональных блоков программного обеспечения, а также функций.

### Пример

Вы создали страницу, в которой пользователь должен сначала ввести свое имя в диалоговом окне, прежде чем они смогут увидеть содержимое. У вас есть список приглашенных пользователей, поэтому другим пользователям будет отправлена ​​ошибка.

Здесь есть несколько сценариев, таких как:

*   Каждый раз, когда вы загружаете страницу, вам нужно ввести свое имя.
*   Если ваше имя находится в списке, диалог исчезнет, ​​и вы увидите статью.
*   Если ваше имя отсутствует в списке, в диалоговом окне появится сообщение об ошибке.

Вы можете записывать тесты приемки для каждой из этих дополнительных функций более крупного диалогового окна

Помимо кода, который обрабатывает инфраструктуру выполнения теста, ваш тест для первого сценария может выглядеть как (в псевдокоде):

Учитывая, что страница открыта Диалоговое окно должно быть видимым Диалоговое окно должно содержать поле ввода И в поле ввода должен быть текст заполнителя «Ваше имя, пожалуйста!»

### Заметки

Приемочные тесты могут быть написаны на любом языке и выполняться с использованием различных доступных инструментов, которые будут заботиться об упомянутой выше инфраструктуре: например, открытие браузера, загрузка страницы, предоставление мнтодам доступа к элементам на странице, библиотеки утверждений и т. Д.

Каждый раз, когда вы пишете часть программного обеспечения, которое будет использоваться снова (даже самостоятельно), это помогает написать для него тест. Когда вы сами или кто-то вносит изменения в этот код, запуск тестов гарантирует, что вы не нарушили существующие функции.

Обычно это выполняется пользователями или экспертами по предметным вопросам. Он также называется тестом на прием пользователей (UAT). UAT включает в себя наиболее распространенные сценарии реальной жизни. В отличие от тестирования системы, он не фокусируется на ошибках или сбоях, а на функциональности. UAT выполняется в конце жизненного цикла тестирования и будет решать, будет ли программное обеспечение перемещено в следующую среду или нет.

Хорошим способом определения того, какие приемочные тесты должны быть написаны, является добавление критериев приемлемости к истории пользователя. С критериями приемлемости вы можете определить, когда пользовательская история готова к развертыванию, и проблема будет завершена в соответствии с вашими пожеланиями.

В проекте Agile важно, чтобы команда имела критерии приемки, определенные для всех пользовательских историй. В процессе тестирования приемочных испытаний будут использоваться определенные критерии для оценки поставляемой функциональности. Когда история может передать все критерии приемки, она завершена.

Приемочное тестирование может также проверять, соответствует ли завершенный эпик / сюжет / задача определенным критериям приемлемости. В отличие от определения сделано, этот критерий может охватывать конкретные деловые случаи, которые команда хочет решить. Это обеспечивает хорошее измерение качества работы.

#### Дополнительная информация:

*   [Международная квалификационная коллегия по тестированию программного обеспечения](http://www.istqb.org/)
