---
title: Behavior Driven Development
localeTitle: Разработка поведения
---
## Разработка поведения

Разработка поведения (BDD) - это процесс разработки программного обеспечения, который появился из ![Разработка, управляемая тестированием (TDD)](../test-driven-development/index.md) , Behavior Driven Development сочетает в себе общие методы и принципы TDD с идеями, основанными на доменном дизайне и объектно-ориентированном анализе и дизайне, для создания групп разработки программного обеспечения и управления с использованием общих инструментов и совместного процесса для совместной работы по разработке программного обеспечения. Это методология разработки программного обеспечения, в которой приложение определяется и конструируется, описывая, как его поведение должно появляться внешнему наблюдателю.

Хотя BDD - это в основном идея о том, как управление разработкой программного обеспечения должно осуществляться как с деловыми интересами, так и с технической точки зрения, практика BDD предполагает использование специализированных программных средств для поддержки процесса разработки.

Хотя эти инструменты часто разрабатываются специально для использования в проектах BDD, их можно рассматривать как специализированные формы инструментария, поддерживающего разработку, основанную на тестах. Инструменты служат для добавления автоматизации к вездесущему языку, который является центральной темой BDD.

BDD фокусируется на:

*   С чего начать в процессе
*   Что тестировать и что не тестировать
*   Сколько нужно проверить за один раз
*   Что нужно назвать испытаниями
*   Как понять, почему тест не прошел

В основе BDD лежит переосмысление подхода к тестированию устройств и приемочным испытаниям, которые, естественно, возникают с этими проблемами. Например, BDD предлагает, чтобы имена единичных тестов были целыми предложениями, начиная с условного глагола (например, «should» на английском языке) и должны быть записаны в порядке ведения бизнеса. Приемочные тесты должны быть написаны с использованием стандартной гибкой структуры пользовательской истории: «В _роли_ я хочу использовать _функцию,_ чтобы _получить выгоду_ ». Критерии приемлемости должны быть записаны с точки зрения сценариев и реализованы в виде классов: при _исходном контексте_ , когда _происходит событие_ , затем _обеспечивайте некоторые результаты_ .

пример
```
Story: Returns go to stock 
 
 As a store owner 
 In order to keep track of stock 
 I want to add items back to stock when they're returned. 
 
 Scenario 1: Refunded items should be returned to stock 
 Given that a customer previously bought a black sweater from me 
 And I have three black sweaters in stock. 
 When he returns the black sweater for a refund 
 Then I should have four black sweaters in stock. 
 
 Scenario 2: Replaced items should be returned to stock 
 Given that a customer previously bought a blue garment from me 
 And I have two blue garments in stock 
 And three black garments in stock. 
 When he returns the blue garment for a replacement in black 
 Then I should have three blue garments in stock 
 And two black garments in stock. 
```

Наряду с этим есть некоторые преимущества:

1.  Все работы по развитию можно проследить непосредственно до бизнес-целей.
2.  Разработка программного обеспечения отвечает потребностям пользователей. Довольные пользователи = хороший бизнес.
3.  Эффективная приоритизация - прежде всего, доставляются важные для бизнеса функции.
4.  Все стороны имеют общее понимание проекта и могут участвовать в сообщении.
5.  Общий язык гарантирует, что каждый (технический или нет) имеет полную видимость в продвижении проекта.
6.  Результирующий дизайн программного обеспечения, который соответствует существующим и поддерживает будущие потребности бизнеса.
7.  Улучшенный код качества, снижающий затраты на обслуживание и минимизирующий риск проекта.

## Больше информации

*   Wiki на [BDD](https://en.wikipedia.org/wiki/Behavior-driven_development)
*   Известной структурой разработки, основанной на поведении (BDD) является [Cucumber](https://cucumber.io/) . Огурец поддерживает многие языки программирования и может быть интегрирован с несколькими структурами; например, [Ruby on Rails](http://rubyonrails.org/) , [Spring Framework](http://spring.io/) и [Selenium](http://www.seleniumhq.org/)
*   https://inviqa.com/blog/bdd-guide