---
title: Code Smells
localeTitle: Код запаха
---
## Код запаха

Код Запах в компьютерном программировании является показателем поверхности, что может возникнуть проблема с вашей системой и качеством вашего кода. Эта проблема может потребовать исправления рефакторинга.

Важно понимать, что вонючий код работает, но не хорошего качества.

#### Примеры

1.  Дублированный код. Блоки кода, которые были реплицированы по всей базе кода. Это может указывать на то, что вам нужно обобщить код на функцию и вызвать его в двух местах, или может быть, что способ работы кода в одном месте полностью не связан с тем, как он работает в другом месте, несмотря на то, что он был скопирован.
2.  Большие классы - классы, имеющие слишком много строк кода. Это может указывать на то, что класс пытается сделать слишком много вещей и должен быть разбит на более мелкие классы.

#### Дополнительная информация:

*   _Рефакторинг: совершенствование дизайна существующего кода - Кент Бек, Мартин Фаулер_
*   _Чистый код: руководство по гибкому программному мастерству - Martin, Robert C. (2009)._
*   [Код запаха в Википедии](https://en.wikipedia.org/wiki/Code_smell)
*   [Код запаха на блоге Джеффа Атвуда (ужас кодирования)](https://blog.codinghorror.com/code-smells/)
*   [Код запаха на Ward Cunningham's C2 Wiki](http://wiki.c2.com/?CodeSmell)
*   [Мартин Фаулер - Код Запах](https://martinfowler.com/bliki/CodeSmell.html)