---
title: Design Patterns
localeTitle: Шаблоны проектирования
---
## Шаблоны проектирования

Шаблон проектирования является общим проектным решением общей проблемы проектирования. Набор шаблонов проектирования для соответствующего поля или домена называется языком шаблонов. Обратите внимание, что на других уровнях также существуют шаблоны: код, параллелизм, архитектура, дизайн взаимодействия ...

В разработке программного обеспечения шаблон разработки программного обеспечения является общим многоразовым решением общей проблемы в рамках данного контекста при разработке программного обеспечения. Это не готовый дизайн, который можно преобразовать непосредственно в исходный или машинный код. Это описание или шаблон для решения проблемы, которая может использоваться во многих разных ситуациях. Шаблоны проектирования - это формализованные передовые методы, которые программист может использовать для решения общих проблем при разработке приложения или системы.

Объектно-ориентированные шаблоны проектирования обычно показывают отношения и взаимодействия между классами или объектами без указания конечных классов приложений или объектов, которые задействованы. Шаблоны, которые подразумевают изменчивое состояние, могут быть непригодными для функциональных языков программирования, некоторые шаблоны могут быть ненужными на языках, которые имеют встроенную поддержку для решения проблемы, которую они пытаются решить, а объектно-ориентированные шаблоны не обязательно подходят для не-объектов ориентированные языки.

Шаблоны проектирования могут рассматриваться как структурированный подход к компьютерному программированию, промежуточный между уровнями парадигмы программирования и конкретным алгоритмом.

Книга, которая популяризировала поле, представляет собой **шаблоны проектирования** Gang of Four (GoF) **: элементы многоразового объектно-ориентированного программного обеспечения** (1994). Он представляет серию (23) шаблонов для обычного (C ++) языка OO, классифицированного в трех типах:

*   **Создание** (для создания объектов): абстрактная фабрика, строитель, фабричный метод, прототип, singleton.
*   **Структурный** (для создания объектов): адаптер, мост, композит, декоратор, фасад, мухи, прокси.
*   **Поведенческий** (для связи между объектами): цепочка ответственности, команда, интерпретатор, итератор, посредник, memmento, observer, состояние, стратегия, метод шаблона, посетитель.

Шаблоны могут использоваться для нескольких целей (обучения, общения, улучшения вашего инструментария), но в гибкой они должны быть реорганизованы из кода с технической задолженностью, а не просто добавлены в начале (появляющийся дизайн / архитектура), поскольку изначально у вас недостаточно знаний о будущей системе, которая будет развиваться. Обратите внимание, что то, что требует шаблон на языке или инструменте, может не понадобиться или уже быть частью другого языка или инструмента. Рамка представляет собой набор взаимодействующих классов, которые составляют многоразовый дизайн для определенного типа программного обеспечения и, как правило, имеют тяжелую структуру.

#### Дополнительная информация:

*   [Википедия по шаблонам проектирования](https://en.wikipedia.org/wiki/Software_design_pattern)
*   [Википедия на GoF Book](https://en.wikipedia.org/wiki/Design_Patterns)
*   [Дизайн шаблонов по созданию источника](https://sourcemaking.com/design_patterns) : список известных шаблонов, доступных в Интернете
*   [Шаблоны программирования игр](http://gameprogrammingpatterns.com/) : книга о шаблонах проектирования, обычно используемых в разработке игр, доступна для бесплатного чтения в Интернете
*   [Объектно-ориентированный дизайн](http://www.oodesign.com/)
*   [Руководство для начинающих по шаблонам проектирования](https://code.tutsplus.com/articles/a-beginners-guide-to-design-patterns--net-12752)
*   [От шаблонов проектирования до теории категорий](http://blog.ploeh.dk/2017/10/04/from-design-patterns-to-category-theory/)