---
title: Lean Software Development
localeTitle: Разработка программного обеспечения для Lean
---
## Разработка программного обеспечения для Lean

### Введение

Lean Software Development - это процесс создания программного обеспечения с уделением особого внимания использованию методов, которые минимизируют дополнительную работу и тратят впустую усилия. Эти методы заимствованы из производственного движения Lean и применяются в контексте разработки программного обеспечения.

### Ключевые идеи

В методологии есть семь принципов, которые включают:

1.  Устранение отходов
2.  Усиление обучения
3.  Решите как можно позже
4.  Постарайтесь как можно быстрее
5.  Уполномочивать команду
6.  Строить целостность в
7.  Посмотреть весь

### Метафоры

Акт программирования рассматривается как конвейер, где каждая функция или исправление ошибок называется «запросом на изменение». Эта сборочная линия «запросов на изменение» затем может рассматриваться как «поток ценности», целью которой является минимизация времени, в течение которого каждый «запрос на изменение» находится на линии перед доставкой.

Программное обеспечение, которое еще не поставлено, рассматривается как «инвентарь», поскольку оно еще не предоставило ценность компании или клиенту. Это включает в себя любое программное обеспечение, которое частично завершено. Поэтому для максимизации пропускной способности важно предоставить множество небольших полных программных продуктов.

Чтобы свести к минимуму «инвентарь», важно отделить контроль над «рабочими», которые будут разработчиками программного обеспечения, поскольку они были бы лучше оснащены для создания автоматизированных процессов для «доказательства ошибок» различных частей сборочной линии.

### Рекомендации

Первоначальным источником письменной документации по методам Lean является книга Lean Software Development, Agile Toolkit от Mary и Tom Poppendieck.

Дополнительные книги автора (ов) включают:

*   Внедрение Lean Software Development: от концепции до наличных денег Мэри Поппендик
*   Ведущая разработка программного обеспечения Lean: результаты не являются точкой Мэри Поппендик