---
title: Moscow
localeTitle: Москва
---
## Москва

## Метод MoSCoW

Одним из значений этого слова является метод MoSCoW - метод приоритизации, используемый в управлении, бизнес-анализе, управлении проектами и разработке программного обеспечения, чтобы достичь общего понимания с заинтересованными сторонами важности, которую они придают каждому требованию, также известному как Определение приоритетов MoSCoW или MoSCoW.

## Приоритизация требований MoSCoW

Все требования важны, но они имеют приоритет, чтобы доставлять самые большие и самые непосредственные выгоды для бизнеса на ранней стадии. Разработчики сначала попытаются доставить все необходимые Должны, Должны иметь и могли бы иметь требования, но требования If и Could будут первыми, которые будут удалены, если время выполнения поставки окажется под угрозой.

Простое английское значение категорий приоритетов имеет ценность для того, чтобы клиенты лучше понимали влияние установления приоритета по сравнению с альтернативами, такими как High, Medium и Low.

Категории обычно понимаются как:

## Должен иметь
```
Requirements labeled as Must have are critical to the current delivery timebox in order for it to be a success. If even one Must have requirement is not included, the project delivery should be considered a failure. MUST can also be considered an acronym for the Minimum Usable SubseT. 
```

## Должен иметь
```
Requirements labeled as Should have are important but not necessary for delivery in the current delivery timebox. While Should have requirements can be as important as Must have, they are often not as time-critical or there may be another way to satisfy the requirement, so that it can be held back until a future delivery timebox. 
```

## Мог бы иметь
```
Requirements labeled as Could have are desirable but not necessary, and could improve user experience or customer satisfaction for little development cost. These will typically be included if time and resources permit. 
```

## Не будет
```
Requirements labeled as Won't have have been agreed by stakeholders as the least-critical, lowest-payback items, or not appropriate at that time. As a result, Won't have requirements are not planned into the schedule for the next delivery timebox. Won't have requirements are either dropped or reconsidered for inclusion in a later timebox. 
```

MoSCoW - это метод крупнозернистой сортировки для определения приоритетов (категоризация) элементов отставания продукта (или требований, прецедентов, историй пользователей ... в зависимости от используемой методологии). MoSCoW часто используется с временным разделением, где фиксируется крайний срок, так что фокус должен соответствовать самым важным требованиям. Термин MoSCoW сам по себе является акронимом, полученным из первой буквы каждой из четырех категорий приоритетности (должен иметь, должен иметь, иметь и не иметь):

*   **Должен иметь** : Критический для текущего времени доставки, чтобы он имел успех. Как правило, это часть MVP (минимальный жизнеспособный продукт).
*   **Должно иметь** : Важно, но не обязательно для доставки в текущем поле времени поставки.
*   **Может быть** : Желательно, но не обязательно, улучшение.
*   **Не будет** : наименее критичных, наименьших окупаемых предметов или не подходит в настоящее время.

При определении приоритетов таким образом может быть достигнуто общее определение проекта и ожидания заинтересованных сторон. Обратите внимание, что MoSCoW немного слабеет о том, как отличить категорию элемента и когда что-то будет сделано, если не в это время.

#### Дополнительная информация:

[Википедия](https://en.wikipedia.org/wiki/MoSCoW_method)