---
title: Nonfunctional Requirements
localeTitle: Нефункциональные требования
---
## Нефункциональные требования

Нефункциональное требование (NFR) - это требование, которое определяет критерии, которые могут использоваться для оценки функционирования системы, а не для конкретного поведения (функциональное требование). Нефункциональные требования часто называют «атрибутами качества», «ограничениями» или «не поведенческими требованиями».

Неофициально, их иногда называют «ными», от таких атрибутов, как стабильность и переносимость. НФР можно разделить на две основные категории:

*   **Исполняемые качества** , такие как безопасность, безопасность и удобство использования, которые наблюдаются во время работы (во время выполнения).
*   **Эволюционные качества** , такие как тестируемость, ремонтопригодность, расширяемость и масштабируемость, которые воплощены в статической структуре системы

Обычно вы можете уточнить нефункциональное требование в наборе функциональных требований в качестве способа детализации и разрешения (частичного) тестирования и проверки.

### Примеры:

*   Принтер должен печатать через 5 секунд после нажатия кнопки
*   Код должен быть написан на Java
*   Пользовательский интерфейс должен быть легко судоходным

#### Дополнительная информация:

*   [Статья в Википедии](https://en.wikipedia.org/wiki/Non-functional_requirement)
*   [ReQtest](http://reqtest.com/requirements-blog/functional-vs-non-functional-requirements/) Объясняет разницу между функциональными и нефункциональными требованиями
*   [Масштабируемые Agile](http://www.scaledagileframework.com/nonfunctional-requirements/) Works в процессе от поиска до тестирования нефункциональных требований