---
title: Rapid Application Development
localeTitle: Быстрая разработка приложений
---
## Быстрая разработка приложений

Разработка Rapid Application Development (RAD) была разработана как реакция на проблемы традиционных методологий разработки программного обеспечения, в частности проблемы долгосрочного развития. В нем также рассматриваются проблемы, связанные с изменением требований в процессе разработки.

Основные принципы RAD заключаются в следующем: 1) Инкрементальное развитие. Это основное средство, с помощью которого RAD обрабатывает меняющиеся требования. Некоторые требования появятся только тогда, когда пользователи видят и испытывают используемую систему. Требования никогда не считаются полными - они меняются со временем из-за меняющихся обстоятельств. Процесс RAD начинается с высокоуровневого, неспецифического списка требований, которые уточняются в процессе разработки. 2) Время. При использовании времени, система делится на несколько компонентов или временных ящиков, которые разрабатываются отдельно. Наиболее важные требования разрабатываются в первом тайм-боксе. Особенности доставляются быстро и часто. 3) Принцип Парето. Также известное как правило 80/20, это означает, что около 80% функциональности системы может быть доставлено с примерно 20% от всех необходимых усилий. Поэтому последние (и самые сложные) 20% требований требуют наибольших усилий и времени для доставки. Таким образом, вы должны выбрать как можно больше из 80% для доставки в первые несколько таймбоксов. Остальное, если оно окажется необходимым, может быть доставлено в последующих тайм-боксах. 4) Правила MoSCoW. MoSCoW - это метод, используемый для определения приоритетности рабочих элементов при разработке программного обеспечения. Элементы оцениваются как должны, должны иметь, иметь или хотели бы иметь. Должны иметь элементы - это те, которые должны быть включены в продукт для его включения в выпуск, а остальные классификации - в нисходящем приоритете. 5) семинары JAD. Совместная разработка приложений (JAD) - это упрощенная встреча, на которой проводится сбор требований, в частности, опрос пользователей разрабатываемой системы. Семинар JAD обычно проходит на ранней стадии процесса разработки, хотя дополнительные совещания могут быть организованы, если потребуется позже в этом процессе. 6) Прототипирование. Построение прототипа помогает установить и уточнить требования пользователя, и в некоторых случаях оно развивается, чтобы стать самой системой. 7) Спонсор и чемпион. Исполнительный спонсор - это кто-то из членов организации, который хочет эту систему, стремится к ее достижению и готов финансировать ее. Чемпионом является кто-то, обычно на более низком уровне старшинства, чем исполнительный директор, который привержен проекту и готов продвинуть его к завершению. 8) Инструменты. RAD обычно использует инструменты как средство ускорения процесса разработки и повышения производительности. Инструменты доступны для управления изменениями, управления конфигурацией и повторного использования кода.

#### Дополнительная информация:

*   https://en.wikipedia.org/wiki/Rapid разработка _приложений_ - статья Википедии о RAD
*   https://www.tutorialspoint.com/sdlc/sdlc _rad_ model.htm - Учебник TutorialsPoint по RAD