---
title: Test Driven Development
localeTitle: Испытательное развитие
---
## Испытательное развитие

Разработка тестового решения (TDD) является одним из подходов Agile Software Development. Он основан на концепции, что

> вы должны написать тестовый пример для своего кода еще до того, как вы напишете код

Здесь мы сначала пишем единичный тест, а затем записываем код для успешного завершения теста. Это экономит время, затрачиваемое на выполнение модульного теста и другого аналогичного теста, поскольку мы идем вперед с успешной итерацией теста, а также для достижения модульности кода. Он состоит в основном из 4 шагов

*   Напишите тестовый пример
    
*   См. Сбой теста (красный)
    
*   Пройдите тест, пройдя любые преступления в процессе (зеленый)
    
*   Рефакторинг кода должен соответствовать стандартам (Refactor)
    
    Эти шаги следуют принципу Red-Green-Refactor. Red-Green убедитесь, что вы пишете простейший код, чтобы решить проблему, в то время как последний шаг гарантирует, что код, который вы пишете, соответствует стандартам.
    

Каждая новая функция вашей системы должна следовать вышеприведенным шагам.

![поток tdd](http://www.agiledata.org/images/tddSteps.jpg)

#### Дополнительная информация:

[Введение](http://agiledata.org/essays/tdd.html) Agile Data [в TDD](http://agiledata.org/essays/tdd.html)

Wiki по [TDD](https://en.wikipedia.org/wiki/Test-driven_development)

Мартин Фаулер [\- TDD Dead?](https://martinfowler.com/articles/is-tdd-dead/) (Серия записанных разговоров по этому вопросу)

Книга Кента Бэка « [Испытательная разработка по примеру»](https://www.amazon.com/Test-Driven-Development-Kent-Beck/dp/0321146530)

Дядя Боб [Циклы TDD](http://blog.cleancoder.com/uncle-bob/2014/12/17/TheCyclesOfTDD.html)