---
title: User Acceptance Tests
localeTitle: Тесты приемки пользователей
---
## Тесты приемки пользователей

При разработке и различных поддисциплинах приемочное тестирование является испытанием, проводимым для определения соответствия требований спецификации или контракта. Это может включать химические тесты, физические тесты или тесты производительности.

В системной инженерии до его поставки может потребоваться тестирование черного ящика, выполняемое в системе (например: часть программного обеспечения, множество изготовленных механических частей или партии химических продуктов).

В тестировании программного обеспечения ISTQB определяет принятие в качестве: формального тестирования в отношении потребностей пользователей, требований и бизнес-процессов, проводимых для определения того, удовлетворяет ли система критериям приемки и позволяет пользователю, клиентам или другим уполномоченным лицам определять, принимать или не принимать система. Приемочные испытания также известны как приемочные испытания пользователей (UAT), тестирование конечных пользователей, тестирование приемочного тестирования (OAT) или полевое (приемное) тестирование.

Тест на дым может использоваться в качестве приемочного теста перед введением сборки программного обеспечения в основной процесс тестирования.

Одним из заключительных шагов в тестировании программного обеспечения является приемочное тестирование пользователей (UAT). UAT гарантирует, что фактические пользователи могут использовать программное обеспечение. Также упоминается как тестирование бета-тестирования, приложений и конечных пользователей.

UAT проверяет, что все работает правильно и что нет сбоев. Те из целевой аудитории должны пройти тестирование; это может состоять из многих людей, вовлеченных в процесс, и любого, кто может протестировать, прежде чем отправиться жить. Обратная связь с этим тестированием направляется команде разработчиков для любых конкретных изменений.

#### Зачем нам UAT

*   Изменения требований могут не сообщаться разработчикам
    
*   Программное обеспечение может не поставлять фактически то, что оно предназначало для
    
*   Некоторым логическим или бизнес-процессам может потребоваться внимание пользователя
    

#### Что требуется, прежде чем мы начнем UAT

*   Полная переоценка завершена и доступна как документально
    
*   Код работает или находится в демонстрационном состоянии
    
*   UAT - среда готова для доступа
    
*   Не должно быть никакого дефекта, который нарушит код
    
*   Данные испытаний, подготовленные в соответствии с LIVE scneario
    

#### Рамки и инструменты, используемые

*   FitNesse

#### Статьи о UAT

*   [7 КЛЮЧИ К УСПЕШНОМУ ИСПЫТАНИЮ ПРИЕМКИ ПОЛЬЗОВАТЕЛЯ](http://blog.debugme.eu/successful-user-acceptance-testing/)
    
*   [AgileUAT: основа для тестирования приёма пользователей на основе пользовательских историй и критериев приема](http://research.ijcaonline.org/volume120/number10/pxc3903533.pdf)
    

#### Дополнительная информация:

https://en.wikipedia.org/wiki/Acceptance\_testing