---
title: User Stories
localeTitle: Истории пользователей
---
Истории пользователей являются частью гибкого подхода, который помогает перенести фокус с написания требований на разговоры о них. Все гибкие истории пользователей включают письменное предложение или два и, что более важно, серию разговоров о желаемой функциональности.

Истории пользователей обычно пишутся с использованием следующего шаблона:

#### Как \[тип пользователя\], я хочу \[некоторую цель\], чтобы \[по какой-то причине или нужно\]

Истории пользователей должны быть написаны в нетехнических терминах с точки зрения пользователя. Сюжет должен подчеркнуть необходимость пользователя, а не как. В истории пользователей не должно быть никаких решений.

Одна из распространенных ошибок, которые возникают при написании пользовательских историй, написана с точки зрения разработчика или решения. Обязательно укажите цель и необходимость, а функциональные требования - позже.

#### Определение пользовательской истории: эпоса и более мелкие истории

Эпоха - это крупная, грубозернистая история. С течением времени он обычно разбивается на несколько пользовательских историй с использованием отзывов пользователей о ранних прототипах и приращениях продукта. Вы можете подумать об этом как заголовке и заполнителе для более подробных историй.

Начиная с эпоса, вы можете набросать функциональность продукта, не переходя к деталям. Это особенно полезно для описания новых продуктов и функций: он позволяет вам захватывать грубый охват, и он покупает вам время, чтобы узнать больше о том, как наилучшим образом удовлетворить потребности пользователей.

Это также сокращает время и усилия, необходимые для интеграции новых идей. Если у вас много подробных рассказов в журнале о работе, то часто сложно и трудоемко относиться к отзывам к соответствующим элементам, и это несет риск введения несоответствий.

Когда мы думаем о возможных историях, важно также учитывать истории «неправильных пользователей» и «несчастливые пути». Как будут обрабатываться исключения системой? Какой обмен сообщениями вы предоставите пользователю? Как злоумышленник может злоупотреблять этой функцией приложения? Эти mal-истории могут сэкономить доработку и стать полезными тестовыми случаями в QA.

#### Дополнительная информация:

*   [Руководство по программному обеспечению Mountain Goat для пользовательских историй](https://www.mountaingoatsoftware.com/agile/user-stories)
*   [Роман Пихлер Руководство по пользовательским рассказам](http://www.romanpichler.com/blog/10-tips-writing-good-user-stories/)