---
title: Behavioral patterns
localeTitle: Поведенческие модели
---
## Поведенческие модели

Поведенческие шаблоны проектирования - это шаблоны проектирования, которые идентифицируют общие проблемы связи между объектами и реализуют эти шаблоны. Таким образом, эти шаблоны увеличивают гибкость при выполнении этого сообщения, делая программное обеспечение более надежным и легким в обслуживании.

Примеры такого типа дизайна включают:

1.  **Схема цепочки ответственности** : объекты команд обрабатываются или передаются другим объектам с помощью объектов, содержащих логические объекты.
2.  **Шаблон команды** : объекты команды инкапсулируют действие и его параметры.
3.  **Шаблон интерпретатора** . Внедрите специализированный компьютерный язык для быстрого решения определенного набора проблем.
4.  **Итератор** : Итераторы используются для доступа к элементам агрегатного объекта последовательно, не подвергая его базовому представлению.
5.  **Схема посредника** : обеспечивает унифицированный интерфейс для набора интерфейсов в подсистеме.
6.  **Memento pattern** : обеспечивает возможность восстановления объекта до его предыдущего состояния (откат).
7.  **Шаблон Null Object** : Предназначен для использования в качестве значения по умолчанию для объекта.
8.  **Шаблон наблюдателя** : aka P **ublish / Подписка** или **прослушиватель** **событий** . Объекты регистрируются, чтобы наблюдать событие, которое может быть поднято другим объектом.
9.  **Слабая контрольная модель** : Отмените наблюдателя от наблюдаемого.
10.  **Стек протокола** : связь обрабатывается несколькими уровнями, которые образуют иерархию инкапсуляции.
11.  **Шаблон запланированной задачи** : задание планируется выполнить с определенным интервалом или временем синхронизации (используется в вычислениях в реальном времени).
12.  **Однопользовательский шаблон посетителя** : оптимизируйте реализацию посетителя, который выделен, используется только один раз, а затем удаляется.
13.  **Спецификация** : рекомбинируемая бизнес-логика логическим способом.
14.  **Шаблон состояния** : чистый способ для объекта частично изменить свой тип во время выполнения.
15.  **Стратегия** : алгоритмы могут выбираться «на лету».
16.  **Шаблон метода шаблона** : Описывает программный скелет программы.
17.  **Шаблон посетителя** : способ отделить алгоритм от объекта.

### источники

[https://en.wikipedia.org/wiki/Behavioral\_pattern](https://en.wikipedia.org/wiki/Behavioral_pattern)