---
title: Creational patterns
localeTitle: Создание шаблонов
---
## Создание шаблонов

Творческие шаблоны проектирования - это шаблоны проектирования, которые касаются механизмов создания объектов, пытаясь создать объекты в соответствии с ситуацией. Основная форма создания объекта может привести к проблемам проектирования или сложности с дизайном. Создание шаблонов проектирования решает эту проблему, как-то контролируя создание этого объекта.

Творческие шаблоны проектирования состоят из двух доминирующих идей. Одним из них является инкапсуляция знаний о том, какие конкретные классы использует система. Другой скрывает, как экземпляры этих конкретных классов создаются и объединяются.

Пять хорошо известных шаблонов проектирования, которые являются частями шаблонов создания:

1.  **Абстрактный шаблон фабрики** , который предоставляет интерфейс для создания связанных или зависимых объектов без указания конкретных классов объектов.
2.  **Builder** , который отделяет построение сложного объекта от его представления, так что один и тот же процесс построения может создавать различные представления.
3.  **Фабричный шаблон метода** , который позволяет классу переносить экземпляр на подклассы.
4.  **Шаблон прототипа** , который определяет тип объекта для создания с использованием прототипического экземпляра и создает новые объекты, клонируя этот прототип.
5.  **Singleton** , который гарантирует, что класс имеет только один экземпляр и предоставляет глобальную точку доступа к нему.

### источники

1.  [Гамма, Эрих; Шлем, Ричард; Джонсон, Ральф; Влиссидес, Джон (1995). Шаблоны проектирования. Массачусетс: Эддисон-Уэсли. п. 81. ISBN 978-0-201-63361-0. Получено 2015-05-22.](http://www.pearsoned.co.uk/bookshop/detail.asp?item=171742)