---
title: Structural patterns
localeTitle: Структурные структуры
---
## Структурные структуры

Структурные шаблоны проектирования - это шаблоны проектирования, которые облегчают дизайн, определяя простой способ реализации отношений между сущностями и отвечают за построение простых и эффективных иерархий классов между различными классами.

Примеры структурных шаблонов включают:

1.  **Шаблон адаптера** : «адаптирует» один интерфейс для класса в тот, который ожидает клиент.
2.  **Конвейер** : используйте несколько адаптеров для целей отладки.
3.  **Retrofit Interface Pattern** : адаптер, используемый в качестве нового интерфейса для нескольких классов одновременно.
4.  **Агрегатный шаблон** : версия составного шаблона с методами агрегирования детей.
5.  **Схема моста** : отделить абстракцию от ее реализации, чтобы они могли варьироваться независимо.
6.  **Надгробный камень** : промежуточный объект «lookup» содержит реальное местоположение объекта.
7.  **Композитный шаблон** : древовидная структура объектов, где каждый объект имеет один и тот же интерфейс.
8.  **Рисунок декоратора** : добавьте дополнительные функциональные возможности для класса во время выполнения, когда подклассы приведут к экспоненциальному росту новых классов.
9.  **Шаблон расширяемости** : aka Framework - скрыть сложный код за простым интерфейсом.
10.  **Фасад** : создать упрощенный интерфейс существующего интерфейса для облегчения использования общих задач.
11.  **Шаблон Flyweight** : большое количество объектов имеет общий объект свойств для экономии места.
12.  **Шаблон маркера** : пустой интерфейс для связывания метаданных с классом.
13.  **Трубы и фильтры** : цепочка процессов, где выход каждого процесса является входом следующего.
14.  **Непрозрачный указатель** : указатель на необъявленный или закрытый тип, чтобы скрыть детали реализации.
15.  **Прокси-шаблон** - класс, функционирующий как интерфейс к другому.

### источники

[https://en.wikipedia.org/wiki/Structural\_pattern](https://en.wikipedia.org/wiki/Structural_pattern)