---
title: Algorithm Performance
localeTitle: Эффективность алгоритма
---
В математике обозначение Big-O является символом, используемым для описания и сравнения _предельного поведения_ функции.  
Предельным поведением функции является то, как функция действует так, как она имеет тенденцию к определенному значению, и в примечании с большими О, обычно она имеет тенденцию к бесконечности.  
Короче говоря, обозначение Big-O используется для описания роста или снижения функции, как правило, в отношении другой функции.

в дизайне алгоритма мы обычно используем нотацию большого О, потому что мы можем видеть, насколько плохой или хороший алгоритм будет работать в худшем режиме. но помните, что это не всегда так, потому что худший случай может быть очень редок, и в этих случаях мы вычисляем средний случай. на данный момент больше не упоминается.

В математике обозначение Big-O является символом, используемым для описания и сравнения _предельного поведения_ функции.

Предельным поведением функции является то, как функция действует так, как она имеет тенденцию к конкретному значению, и в примечаниях с большими О, обычно она имеет тенденцию к бесконечности.

Короче говоря, обозначение Big-O используется для описания роста или снижения функции, как правило, в отношении другой функции.

ПРИМЕЧАНИЕ: x ^ 2 эквивалентно x \* x или 'x-squared'\]

Например, мы говорим, что x = O (x ^ 2) для всех x> 1, или, другими словами, x ^ 2 является верхней границей по x и, следовательно, растет быстрее.  
Символ утверждения типа x = O (x ^ 2) для всех x> _n_ можно заменить x <= x ^ 2 для всех x> _n,_ где _n_ - минимальное число, удовлетворяющее требованию, в этом случае 1.

Эффективно мы говорим, что функция f (x), то есть O (g (x)), растет медленнее, чем g (x).

Сравнительно, в информатике и разработке программного обеспечения мы можем использовать примечание «большой О», чтобы описать эффективность алгоритмов с помощью его временной и пространственной сложности.

**Космическая сложность** алгоритма относится к его размеру памяти относительно размера ввода.

В частности, при использовании записи с большим О мы описываем эффективность алгоритма по отношению к входу: _n_ , обычно по мере приближения _n_ к бесконечности.  
При изучении алгоритмов мы обычно хотим снизить сложность времени и пространства. Сложность времени o (1) указывает на постоянное время.

Благодаря сравнению и анализу алгоритмов мы можем создавать более эффективные приложения.

Для производительности алгоритма мы имеем два основных фактора:

*   **Время** : нам нужно знать, сколько времени требуется для запуска алгоритма для наших данных и как он будет расти по размеру данных (или в некоторых случаях других факторов, таких как количество цифр и т. Д.).
    
*   **Пространство** : наша память - это финал, поэтому нам нужно знать, сколько свободного пространства нам нужно для этого алгоритма, и как время, которое нам нужно, чтобы проследить его рост.
    

Следующие 3 обозначения в основном используются для представления временной сложности алгоритмов:

1.  **Θ Обозначение** : тета-нотация ограничивает функции сверху и снизу, поэтому определяет точное поведение. мы можем сказать, что мы имеем обозначение тета, когда наихудший случай и лучший случай одинаковы.
    
    > Θ (g (n)) = {f (n): существуют положительные константы c1, c2 и n0 такие, что 0 <= c1 _g (n) <= f (n) <= c2_ g (n) для всех n> = n0}
    
2.  **Big O Notation** : **нотация** Big O определяет верхнюю границу алгоритма. Например, Insertion Sort принимает линейное время в лучшем случае и квадратичное время в худшем случае. Мы можем с уверенностью сказать, что временная сложность сортировки Insertion равна _O_ ( _n ^ 2_ ).
    
    > O (g (n)) = {f (n): существуют положительные константы c и n0 такие, что 0 <= f (n) <= cg (n) для всех n> = n0}
    
3.  **Ω Обозначение** : **нотация** Ω обеспечивает нижнюю границу алгоритма. он показывает самый быстрый ответ для этого алгоритма. > Ω (g (n)) = {f (n): существуют положительные константы c и n0 такие, что 0 <= cg (n) <= f (n) для всех n> = n0}.
    

## Примеры

В качестве примера мы можем рассмотреть временную сложность алгоритма [\[пузырьковой сортировки\]](https://github.com/FreeCodeCamp/wiki/blob/master/Algorithms-Bubble-Sort.md#algorithm-bubble-sort) и выразить его с помощью записи с большими нотами.

#### Bubble Сортировать:

```javascript
    // Function to implement bubble sort 
    void bubble_sort(int array<a href='http://bigocheatsheet.com/' target='_blank' rel='nofollow'>], int n) 
    { 
        // Here n is the number of elements in array 
        int temp; 
        for(int i = 0; i < n-1; i++) 
        { 
            // Last i elements are already in place 
            for(int j = 0; j < ni-1; j++) 
            { 
                if (array[j] > array[j+1]) 
                { 
                    // swap elements at index j and j+1 
                    temp = array[j]; 
                    array[j] = array[j+1]; 
                    array[j+1] = temp; 
                } 
            } 
        } 
    } 
```

Посмотрев на этот код, мы видим, что в лучшем случае, когда массив уже отсортирован, программа будет делать только _n_ сравнения, поскольку никакие свопы не будут происходить.  
Поэтому мы можем сказать, что наилучшая временная сложность сортировки пузырьков равна O ( _n_ ).

Изучая сценарий наихудшего случая, когда массив находится в обратном порядке, первая итерация будет производить _n_ сравнений, в то время как следующий должен будет сделать _n_ - 1 сравнений и т. Д., Пока не будет сделано только одно сравнение.  
Таким образом, для этого случая обозначение Big-O имеет вид _n_ \* \[( _n_ - 1) / 2\], которое = 0,5 _n_ ^ 2 - 0,5 _n_ = O ( _n_ ^ 2), поскольку _n_ ^ 2 член доминирует над функцией, которая позволяет нам игнорировать другой член функции.

Мы можем подтвердить этот анализ с помощью \[этого удобного листа cheat Big-O, который отличается сложностью во времени большого количества часто используемых структур данных и алгоритмов

Очень очевидно, что в то время как для небольших случаев использования эта сложность времени может быть в порядке, при крупномасштабной сортировке пузырьков это просто нехорошее решение для сортировки.  
Это мощь нотации O-O: она позволяет разработчикам легко увидеть потенциальные узкие места их приложения и предпринять шаги, чтобы сделать их более масштабируемыми.

Для получения дополнительной информации о том, почему важная нотация и анализ алгоритма важны, посетите этот [видеоролик](https://www.freecodecamp.com/videos/big-o-notation-what-it-is-and-why-you-should-care) !