---
title: B Trees
localeTitle: B Деревья
---
## B Деревья

# Введение

B-Tree - это самобалансирующееся дерево поиска. В большинстве других самоустанавливающихся деревьев поиска (например, AVL и Red Black Trees) предполагается, что все в основной памяти. Чтобы понять использование B-деревьев, мы должны думать о огромном количестве данных, которые не могут вписываться в основную память. Когда число клавиш велико, данные считываются с диска в виде блоков. Время доступа к диску очень велико по сравнению с временем доступа к основной памяти. Основная идея использования B-Trees - уменьшить количество обращений к диску. Большинство операций с деревом (поиск, вставка, удаление, макс, мин, ..etc) требуют O (h) доступа к диску, где h - высота дерева. B-дерево - жирное дерево. Высота B-деревьев поддерживается на низком уровне, помещая максимально возможные ключи в узел B-Tree. Как правило, размер узла B-Tree поддерживается равным размеру блока диска. Так как h для B-Tree является низким, общий доступ к диску для большинства операций значительно уменьшается по сравнению с сбалансированными двоичными деревьями поиска, такими как AVL Tree, Red Black Tree, ..etc.

Свойства B-Tree: 1) Все листья находятся на одном уровне. 2) B-Tree определяется термином «минимальная степень» t. Значение t зависит от размера блока диска. 3) Каждый узел, кроме root, должен содержать не менее t-1 ключей. Корень может содержать минимум 1 ключ. 4) Все узлы (включая корень) могут содержать не более 2 т - 1 ключей. 5) Число дочерних узлов узла равно числу ключей в нем плюс 1. 6) Все ключи узла сортируются в порядке возрастания. Ребенок между двумя ключами k1 и k2 содержит все клавиши в диапазоне от k1 и k2. 7) B-Tree растет и сжимается от корня, что не похоже на двоичное дерево поиска. Деревья двоичного поиска растут вниз, а также сокращаются вниз. 8) Как и другие сбалансированные двоичные деревья поиска, сложность времени поиска, вставки и удаления - O (Logn).

Поиск: Поиск аналогичен поиску в двоичном дереве поиска. Пусть ключ, подлежащий поиску, будет k. Мы начинаем с корня и рекурсивно переходим вниз. Для каждого посещенного нелистового узла, если узел имеет ключ, мы просто возвращаем узел. В противном случае мы возвращаемся к соответствующему дочернему элементу (дочернему, который находится непосредственно перед первым большим ключом) узла. Если мы достигнем листового узла и не найдем k в листовом узле, мы возвращаем NULL.

Траверс: Обход также похож на обход двоичного дерева. Мы начинаем с самого левого ребенка, рекурсивно печатаем самого левого ребенка, затем повторяем тот же процесс для оставшихся детей и ключей. В итоге рекурсивно напечатайте самый правый ребенок.

![alt text](https://upload.wikimedia.org/wikipedia/commons/thumb/b/b0/Full_binary.svg/220px-Full_binary.svg.png "Binary tree")
