---
title: Divide and Conquer Algorithms
localeTitle: Разделить и покорить алгоритмы
---
## Разделить и покорить алгоритмы

Разделить и покорить | (Вступление) Подобно Greedy и Dynamic Programming, Divide and Conquer - алгоритмическая парадигма. Типичный алгоритм Divide и Conquer решает проблему, используя следующие три шага.

1.  Разделить: разбить данную проблему на подзадачи того же типа.
2.  Conquer: рекурсивно решать эти подзадачи
3.  Комбинат: надлежащим образом объедините ответы

Ниже приведены некоторые стандартные алгоритмы, которые являются алгоритмами Divide и Conquer.

1) Бинарный поиск - это алгоритм поиска. На каждом шаге алгоритм сравнивает входной элемент x со значением среднего элемента в массиве. Если значения совпадают, верните индекс из середины. В противном случае, если x меньше среднего элемента, тогда алгоритм повторяется для левой части среднего элемента, а другой - для правой части среднего элемента.

2) Quicksort - это алгоритм сортировки. Алгоритм выбирает элемент поворота, перестраивает элементы массива таким образом, что все элементы, меньшие, чем выбранный элемент поворота, перемещаются влево от оси вращения, а все более крупные элементы перемещаются в правую сторону. Наконец, алгоритм рекурсивно сортирует подмассивы слева и справа от элемента поворота.

3) Merge Sort также является алгоритмом сортировки. Алгоритм делит массив на две половины, рекурсивно сортирует их и, наконец, объединяет две отсортированные половинки.

4) Ближайшая пара точек Задача состоит в том, чтобы найти ближайшую пару точек в множестве точек в плоскости xy. Задача может быть решена в O (n ^ 2) раз, вычисляя расстояния каждой пары точек и сравнивая расстояния для нахождения минимума. Алгоритм Divide и Conquer решает проблему в O (nLogn) времени.

5) Алгоритм Штрассена - эффективный алгоритм умножения двух матриц. Простым методом для умножения двух матриц требуется 3 вложенных цикла и O (n ^ 3). Алгоритм Штрассена умножает две матрицы в O (n ^ 2.8974).

6) Алгоритм быстрого преобразования Фурье Кули-Туки - наиболее распространенный алгоритм БПФ. Это алгоритм разделения и покоя, который работает в O (nlogn) времени.

7) Алгоритм Карацубы был первым алгоритмом умножения асимптотически быстрее, чем квадратичный алгоритм «классной школы». Это уменьшает умножение двух n-разрядных чисел на максимум до n ^ 1,585 (что является приближением к log 3 в базе 2) однозначных продуктов. Поэтому он быстрее, чем классический алгоритм, который требует n ^ 2 однозначных продуктов.

### Divide and Conquer (D & C) и динамическое программирование (DP)

Обе парадигмы (D & C и DP) делят данную проблему на подзадачи и решают подзадачи. Как выбрать один из них для данной проблемы? Divide и Conquer следует использовать, когда одни и те же подзадачи не оцениваются много раз. В противном случае следует использовать динамическое программирование или памятку.

Например, Binary Search - это алгоритм Divide и Conquer, мы никогда не оцениваем одни и те же подзадачи снова. С другой стороны, для вычисления n-го числа Фибоначчи должно быть предпочтительным динамическое программирование.