---
title: Embarassingly Parallel Algorithms
localeTitle: Эмбирирующие параллельные алгоритмы
---
## Эмбирирующие параллельные алгоритмы

При параллельном программировании неловко параллельным алгоритмом является тот, который не требует связи или зависимости между процессами. В отличие от распределенных вычислительных задач, требующих связи между задачами, особенно на промежуточных результатах, смущающие параллельные алгоритмы легко выполнять на фермах серверов, которым не хватает специальной инфраструктуры, используемой в истинном суперкомпьютерном кластере. Из-за характера смущающих параллельных алгоритмов они хорошо подходят для больших распределенных платформ на базе Интернета и не страдают от параллельного замедления. Противоположностью неловко параллельных проблем являются, по сути, серийные проблемы, которые не могут быть распараллелены вообще. Идеальный случай смущающих параллельных алгоритмов можно резюмировать следующим образом:

*   Все подзадачи или задачи определены до начала вычислений.
*   Все подрешения хранятся в независимых ячейках памяти (переменные, элементы массива).
*   Таким образом, вычисление подрешений полностью независимо.
*   Если вычисления требуют некоторой начальной или окончательной связи, мы называем это почти неловко параллельным.

Многие могут задаться вопросом о этимологии термина «смущающе». В этом случае, смущающе не имеет ничего общего с смущением; на самом деле это означает переизбыток - здесь речь идет о проблемах с параллелизацией, которые «смущающе легки».

Общим примером неловко параллельной проблемы является обработка 3D-видео, обрабатываемая блоком обработки графики, где каждый кадр или пиксель можно обрабатывать без взаимозависимости. Некоторые другие примеры - это программное обеспечение для сгибания белков, которое может работать на любом компьютере, причем каждая машина выполняет небольшую часть работы, генерирует все подмножества, случайные числа и моделирование методом Монте-Карло.