---
title: Flood Fill Algorithm
localeTitle: Алгоритм заполнения паводков
---
## Алгоритм заполнения паводков

Flood fill - это алгоритм, используемый в основном для определения ограниченной области, связанной с данным узлом в многомерном массиве. это близкое сходство с инструментом ковша в программах рисования.

Наиболее подходящая реализация алгоритма представляет собой рекурсивную функцию на основе стека, и об этом мы поговорим следующий.

### Как это работает?

Проблема довольно проста и обычно следует следующим шагам:

1.  Возьмите позицию начальной точки.
2.  Решите, хотите ли вы идти в 4 направлениях ( **N, S, W, E** ) или 8 направлений ( **N, S, W, E, NW, NE, SW, SE** ).
3.  Выберите цвет замены и целевой цвет.
4.  Путешествуйте в этих направлениях.
5.  Если плитка, на которой вы приземляетесь, является мишенью, используйте ее с выбранным цветом.
6.  Повторяйте 4 и 5, пока не повсюду в пределах границ.

Возьмем в качестве примера следующий массив:

![alt text](https://github.com/firealex2/Codingame/blob/master/small%208%20grid%20paintefffd.png)

Красный квадрат - это начальная точка, а серые квадраты - это так называемые стены.

Для получения дополнительной информации, вот фрагмент кода, описывающий функцию:

```c++
int wall = -1; 
 
 void flood_fill(int pos_x, int pos_y, int target_color, int color) 
 { 
 
   if(a[pos_x][pos_y] == wall || a[pos_x][pos_y] == color) // if there is no wall or if i haven't been there 
      return;                                              // already go back 
 
   if(a[pos_x][pos_y] != target_color) // if it's not color go back 
      return; 
 
   a[pos_x][pos_y] = color; // mark the point so that I know if I passed through it. 
 
   flood_fill(pos_x + 1, pos_y, color);  // then i can either go south 
   flood_fill(pos_x - 1, pos_y, color);  // or north 
   flood_fill(pos_x, pos_y + 1, color);  // or east 
   flood_fill(pos_x, pos_y - 1, color);  // or west 
 
   return; 
 
 } 
```

Как видно выше, отправной точкой является (4,4). После вызова функции для начальных координат **x = 4** и **y = 4** , Я могу начать проверять, нет ли стены или цвета на месте. Если это действительно, я отмечаю пятно одним **«цветным» цветом,** и начните проверять другие квадраты adiacent.

Подойдя к югу, мы перейдем к пункту (5,4), и функция снова запустится.

### Проблема с физической нагрузкой

Я всегда считал, что решение (или более) проблемы / с использованием недавно выученного алгоритма - лучший способ полностью понять концепт.

Итак, вот что:

**Утверждение:**

В двумерном массиве вам предоставляется n число **«островов»** . Попытайтесь найти самую большую площадь острова и соответствующий остров число. 0 обозначает воду и любые другие х между 1 и n отмечает один квадрат от поверхности, соответствующей на остров х.

**вход**

*   **n** - количество островов.
*   **l, c** - размеры матрицы.
*   следующие **l** строк, **c** чисел, дающих **l-** ю строку матрицы.

**Выход**

*   **i** - номер острова с наибольшей площадью.
*   **A** - площадь **i** -го острова.

**Пример:**

У вас есть следующий ввод:

```c++
2 4 4 
 0 0 0 1 
 0 0 1 1 
 0 0 0 2 
 2 2 2 2 
```

Для чего вы получите остров нет. 2 как самый большой остров площадью 5 квадратов.

### Советы

Проблема довольно проста, но вот несколько советов:
```
1. Use the flood-fill algorithm whenever you encounter a new island. 
 2. As opposed to the sample code, you should go through the area of the island and not on the ocean (0 tiles). 

```