---
title: Algorithms
localeTitle: Алгоритмы
---
## Алгоритмы

В информатике алгоритм является однозначной спецификацией того, как решить класс проблем. Алгоритмы могут выполнять вычисления, обработку данных и автоматизированные задачи рассуждения.

Алгоритм - эффективный метод, который может быть выражен в конечном объеме пространства и времени и в определенном формальном языке для вычисления функции. Исходя из начального состояния и начального ввода (возможно, пустого), инструкции описывают вычисление, которое при его выполнении проходит через конечное число четко определенных последовательных состояний, в конечном итоге создавая «выход» и заканчивая в конечном состоянии. Переход от одного состояния к другому не обязательно детерминирован; некоторые алгоритмы, известные как рандомизированные алгоритмы, включают случайный ввод.

Существуют определенные требования, которым должен следовать алгоритм:

1.  Определенность: каждый шаг в этом процессе точно определен.
2.  Эффективность вычисления: каждый шаг процесса может выполняться компьютером.
3.  Конечность: программа в конечном итоге успешно завершится.

Некоторые распространенные типы алгоритмов включают алгоритмы сортировки, алгоритмы поиска и алгоритмы сжатия. Классы алгоритмов включают Graph, Dynamic Programming, Sorting, Search, Strings, Math, Computational Geometry, Optimization и Miscellaneous. Хотя технически это не класс алгоритмов, структуры данных часто группируются вместе с ними.

### КПД

Алгоритмы чаще всего оцениваются по их эффективности и количеству вычислительных ресурсов, которые они требуют для выполнения своей задачи. Общим способом оценки алгоритма является рассмотрение его временной сложности. Это показывает, как время работы алгоритма растет с увеличением размера ввода. Поскольку сегодня алгоритмы должны работать с большим количеством входящих данных, для наших алгоритмов очень важно иметь достаточно быстрое время работы.

### Алгоритмы сортировки

Алгоритмы сортировки бывают разных видов в зависимости от вашей необходимости. Некоторые, очень распространенные и широко используемые:

#### Быстрая сортировка

Нет сортировки, которая может закончиться без быстрой сортировки. Основная концепция приведена в ссылке ниже. [Быстрая сортировка](http://me.dt.in.th/page/Quicksort/)

#### Сортировка слиянием

Это алгоритм сортировки, который опирается на понятие, как отсортированные массивы объединяются, чтобы дать один отсортированный массив. Об этом подробнее здесь- [Сортировка слиянием](https://www.geeksforgeeks.org/merge-sort/)

Учебная программа freeCodeCamp сильно подчеркивает создание алгоритмов. Это потому, что алгоритмы в обучении - это хороший способ практиковать навыки программирования. Интервьюеры чаще всего тестируют кандидатов по алгоритмам во время собеседований на собеседовании разработчиков.

### Дополнительные ресурсы

[Введение в алгоритмы | Краш-курс: информатика](https://www.youtube.com/watch?v=rL8X2mlNHPM)

Это видео дает доступное и живое введение в алгоритмы, ориентированные на алгоритмы сортировки и поиска по графику.

[Что такое Алгоритм и почему вы должны заботиться? | Ханская академия](https://www.youtube.com/watch?v=CvSOaYi89B4)

В этом видео представлены алгоритмы и кратко обсуждается их использование в больших профилях.

[15 алгоритмов сортировки за 6 минут | Тимо Бинманн](https://www.youtube.com/watch?v=kPRA0W1kECg)

Это видео визуально демонстрирует некоторые популярные алгоритмы сортировки, которые обычно преподают в курсах программирования и компьютерных наук.

[Алгоритм визуализатора](http://algo-visualizer.jasonpark.me)

Это также очень хороший проект с открытым исходным кодом, который помогает вам визуализировать алгоритмы.
