---
title: Linear Search
localeTitle: Линейный поиск
---
## Линейный поиск

Предположим, вам предоставлен список или массив элементов. Вы ищете определенный предмет. Как ты это делаешь?

Найдите номер 13 в данном списке.

![Линейный поиск 1](https://i.imgur.com/ThkzYEV.jpg)

Вы просто смотрите на список, и вот он!

![Линейный поиск 2](https://i.imgur.com/K7HfCly.jpg)

Теперь, как вы говорите компьютеру, чтобы его найти.

Компьютер не может смотреть больше, чем значение в данный момент времени. Поэтому он берет один элемент из массива и проверяет, совпадает ли он с тем, что вы ищете.

![Линейный поиск 3](https://i.imgur.com/ZOSxeZD.jpg)

Первый элемент не совпал. Поэтому переходите к следующему.

![Линейный поиск 4](https://i.imgur.com/SwKsPxD.jpg)

И так далее…

Это делается до тех пор, пока не будет найдено совпадение или пока все элементы не будут проверены.

![Линейный поиск 5](https://i.imgur.com/3AaViff.jpg)

В этом алгоритме вы можете остановиться, когда элемент найден, и тогда нет необходимости смотреть дальше.

Итак, сколько времени потребуется на операцию линейного поиска? В лучшем случае вам может повезти, и предмет, на который вы смотрите, может быть, на первой позиции в массиве! Но в худшем случае вам придется смотреть на каждый элемент, прежде чем вы найдете элемент на последнем месте или до того, как осознаете, что элемент не находится в массиве.

Поэтому сложность линейного поиска заключается в следующем: O (n).

Если элемент, подлежащий поиску, возглавляет первый блок памяти, тогда сложность будет: O (1).

Код для функции линейного поиска в JavaScript показан ниже. Эта функция возвращает позицию элемента, который мы ищем в массиве. Если элемент отсутствует в массиве, функция возвращает null.

### Пример в Javascript

```javascript
function linearSearch(arr, item) { 
  // Go through all the elements of arr to look for item. 
  for (var i = 0; i < arr.length; i++) { 
    if (arr[i] === item) { // Found it! 
      return i; 
    } 
  } 
 
  // Item not found in the array. 
  return null; 
 } 
```

### Пример в Ruby

```ruby
def linear_search(target, array) 
  counter = 0 
 
  while counter < array.length 
    if array[counter] == target 
      return counter 
    else 
      counter += 1 
    end 
  end 
  return nil 
 end 
```

### Пример в C ++

```c++
int linear_search(int arr[],int n,int num) 
 { 
    for(int i=0;i<n;i++){ 
        if(arr[i]==num) 
            return i; 
   } 
   // Item not found in the array 
   return -1; 
 } 
```

### Пример в Python

```python
def linear_search(array, num): 
    for i in range(len(array)): 
        if (array[i]==num): 
            return i 
    return -1 
```

## Глобальный линейный поиск

Что делать, если вы ищете несколько вхождений элемента? Например, вы хотите увидеть, сколько 5 в массиве.

Цель = 5

Массив = \[1, 2, 3, 4, 5, 6, 5, 7, 8, 9, 5\]

Этот массив имеет 3 входа 5s, и мы хотим вернуть индексы (где они находятся в массиве) всех из них. Это называется глобальным линейным поиском, и вам нужно будет настроить свой код, чтобы вернуть массив указательных точек, в которых он обнаруживает целевой элемент. Когда вы найдете элемент индекса, который соответствует вашей цели, в массиве результатов будет добавлена ​​точка-указатель (счетчик). Если он не соответствует коду, он продолжит движение к следующему элементу массива, добавив 1 к счетчику.

```ruby
def global_linear_search(target, array) 
  counter = 0 
  results = [] 
 
  while counter < array.length 
    if array[counter] == target 
      results << counter 
      counter += 1 
    else 
      counter += 1 
    end 
  end 
 
  if results.empty? 
    return nil 
  else 
    return results 
  end 
 end 
```

## Почему линейный поиск неэффективен

Нет никаких сомнений в том, что линейный поиск прост, но поскольку он сравнивает каждый элемент один за другим, он занимает много времени и, следовательно, не очень эффективен. Если нам нужно найти число, скажем, 1000000 номеров и номеров находится в последнем месте, техника линейного поиска станет довольно утомительной. Итак, также узнайте о сортировке пузырьков, быстрой сортировке и т. Д.

#### Соответствующее видео:

#### Другие источники

[Линейный поиск - CS50](https://www.youtube.com/watch?v=vZWfKBdSgXI)