---
title: Rabin Karp Algorithm
localeTitle: Алгоритм Рабина Карпа
---
## Алгоритм Рабина-Карпа

*   Алгоритм поиска / поиска строк, разработанный Майклом О. Рабиным и Ричардом М. Карпом.
*   Использует метод **_хэширования_** и **_грубую силу_** для сравнения.

#### Важные условия

*   **_pattern_** - строка, подлежащая поиску. Рассмотрим длину шаблона как **_M_** символов.
*   **_текст_** - это весь текст, из которого следует искать шаблон. Рассмотрим длину текста как **_N_** символов.

#### Что такое сравнение грубой силы?

При сравнении грубой силы каждый символ шаблона сравнивается с каждым символом текста до тех пор, пока не будут найдены символы, не соответствующие символу.

#### Работа алгоритма Рабина-Карпа

1.  Рассчитать хэш-значение _шаблона_
2.  Рассчитать хэш-значение первых _M_ символов _текста_
3.  Сравните оба значения хэша
4.  Если они не равны, вычислите хэш-значение для следующих _M_ символов _текста_ и сравните их снова.
5.  Если они равны, выполните сравнение грубой силы.
```
hash_p = hash value of pattern 
 hash_t = hash value of first M letters in body of text 
 do 
    if (hash_p == hash_t) 
        brute force comparison of pattern and selected section of text 
    hash_t= hash value of next section of text, one character over 
 while (end of text or brute force comparison == true) 
```

#### Преимущество над алгоритмом наивного строкового соответствия

Этот метод приводит только к одному сравнению для каждой подпоследовательности текста, и грубая сила требуется только тогда, когда значения хэша совпадают.

#### Приложения

*   **_Обнаружение плагиата_**

#### Дополнительная информация:

[Рабин-Карп в Википедии](https://en.wikipedia.org/wiki/Rabin%E2%80%93Karp_algorithm/)