---
title: Android core components
localeTitle: Основные компоненты Android
---
# Основные компоненты Android

Основными компонентами являются элементы, из которых состоит приложение для Android. Каждый из них имеет свою собственную цель и жизненный цикл, но не все из них независимы. Существуют следующие элементы:

*   Мероприятия
*   Сервисы
*   Трансляционные приемники
*   Поставщики контента

## [Мероприятия](https://developer.android.com/guide/components/activities/)

_Активность_ - это компонент, который имеет пользовательский интерфейс и представляет собой один экран. Приложение может выполнять одновременно несколько действий, каждое из которых может быть точкой входа для самого приложения пользователя или системы (действие приложения, которое хочет открыть другое действие, принадлежащее одному и тому же приложению или другому).

## [Сервисы](https://developer.android.com/guide/components/services)

_Служба_ представляет собой компонент без пользовательского интерфейса для выполнения длительных операций в фоновом режиме. Существует два вида услуг:

*   услуги _переднего плана_ : они строго связаны с взаимодействием пользователя (например, с воспроизведением музыки), поэтому их сложнее убрать.
*   _фоновые_ службы: они напрямую не связаны с деятельностью пользователя, поэтому их можно исключить, если требуется больше ОЗУ.

## [Трансляционные приемники](https://developer.android.com/guide/components/broadcasts)

_Широковещательный приемник_ - это еще один компонент без пользовательского интерфейса (кроме уведомления о статусной строке), который позволяет системе отправлять события из / в приложение, даже если последний не был ранее запущен.

## [Поставщики контента](https://developer.android.com/guide/topics/providers/content-providers)

_Поставщик контента_ - это компонент, используемый для управления набором данных приложения для совместного использования с другими приложениями. Каждый элемент, сохраненный в поставщике контента, идентифицируется схемой URI.

Подробную информацию об этой теме см. В официальной документации по [основам Android.](https://developer.android.com/guide/components/fundamentals)

