---
title: Android Development
localeTitle: Разработка для Android
---
# Разработка для Android

Приложения для Android могут стать отличным и интересным способом проникнуть в мир программирования. Официально программисты могут использовать Java, Kotlin или C++ для разработки для Android. Но с некоторыми ограничениями API можно использовать и такие языки, как JavaScript, C, или даже assembly (возможности безграничны).

Из простых игр и служебных приложений для полномасштабных музыкальных игроков существует множество возможностей для создания чего-то значимого для Android. Сообщество разработчиков Android весьма велико, а документацию и ресурсы легко найти в интернете. Всё это помогает решать любые типичные проблемы, с которыми можно столкнуться при Android разработке.

Конечно, есть определенная кривая обучения, чтобы привыкнуть к платформе Android, но как только вы поймёте основные компоненты, составляющие приложения, остальное придёт естественным образом.

Кривая обучения, используемая в Android, имеет относительно меньший наклон по сравнению с изучением других технологий, таких как NodeJS. Также относительно легко понять и внести вклад в AOSP, размещенную Google. Проект можно найти [здесь](https://source.android.com/)

## Начало работы

Ознакомьтесь с руководствами в этой папке, чтобы узнать о 4 [основных компонентах](core-components/index.md), составляющих приложение для Android, и о том, как вы можете начать с примера приложения, а затем углубиться в более сложные темы, такие как фрагменты и систему сборки Gradle. Затем ознакомьтесь с руководством по спецификации материалов, чтобы узнать, как сделать ваши приложения красивыми и удобными для пользователя.

### Настройка и начало работы с Android Studio

Перейдите по этой [ссылке](https://www.oracle.com/technetwork/java/javase/downloads/index.html) и установите последнюю версию JDK. Теперь загрузите Android Studio и набор инструментов Android SDK [здесь](https://developer.android.com/studio/). Установите Android Studio и SDK. Обратите внимание на местоположение SDK. Если вы столкнулись с какой-либо ошибкой, перейдите к настройкам позже, чтобы решить эту проблему.

Наконец, научитесь интегрировать сторонние библиотеки и службы Firebase, чтобы добавить функциональность в ваше приложение. Будет полезно, если вы посмотрите официальную документацию по каждому компоненту.

### Официальная документация

[Руководство для разработчиков Google для Android](https://developer.android.com/training/index.html)

#### Java против Kotlin

С тех пор, как Google объявил Kotlin официальным языком разработки Android в Google IO в 2017 году, программисты, которые хотят стать разработчиками Android, находятся в дилемме. Перед ними стоит большой вопрос: должны ли они изучать Kotlin или Java.

##### Начинающие разработчики Android должны начать с Java

Прежде всего, развитие Android - это еще не все; как программист, вы можете начать свою карьеру с разработки Android, но если вы начнете с хорошо зарекомендовавшего себя языка, такого как Java, вы становитесь частью более крупного сообщества и рынка Java, что напрямую означает больше возможностей для работы.

Вторая и более важная вещь заключается в том, что существует огромное сообщество программистов на Java, что означает, что вы можете найти ответы, когда вы застряли. Это очень важно, потому что, как новичок, вы столкнетесь с множеством технических проблем, и вы можете не знать, с чего начать, когда вы застряли. Когда вы ищете в Google проблему с Java, вы обязательно получите ответы; То же самое нельзя сказать о Kotlin, ведь он является относительно новым языком программирования.

###### Программисты Java должны изучать Kotlin

Теперь вернемся ко второму набору программистов, которые хотят изучать разработку Android: разработчики Java. Для них я считаю, что лучше всего изучить Kotlin, потому что это действительно повышает производительность.

Класс, состоящий из 50 строк кода на Java, действительно может быть написан только в одной строке в Kotlin. Это может помочь вам избежать шаблонного кода. Например, вам не нужно указывать геттеры и сеттеры, методы equals(), hashCode() или toString(). Kotlin может генерировать все это сам по себе.

Если вы не знаете, Kotlin был разработкой JetBrains, компанией, создавшей одну из самых популярных Java IDE, IntelliJ IDEA. Они были магазином Java и разрабатывали IDE, такие как IntelliJ IDEA, PyCharm и ReSharper, все на Java, и создали Kotlin для повышения производительности, но в то же время они не могут переписать весь свой код в Котлине, поэтому они сделали Kotlin полностью совместимым с Java.

Поскольку Kotlin генерирует байт-код Java, вы можете использовать свои любимые фреймворки и библиотеки Java в Kotlin, и ваши друзья с Java могут также использовать любой код на Kotlin, который вы пишете.

### Практика

[Google Codelabs для повышения навыков](https://codelabs.developers.google.com)

### Консоль разработчика Google

[Консоль разработчика Google](https://developer.android.com/distribute/console/)

### Курсы

[Программа Udacity для Android Nanodegree](https://udacity.com/course/android-developer-nanodegree-by-google--nd801)

### Разработка приложений для Android

Лучшая часть обучения Android - это курсы и материалы, доступные онлайн, бесплатно. Ссылка на курс здесь - [Разработка приложений для Android](https://udacity.com/course/new-android-fundamentals--ud851).
