---
title: Animations
localeTitle: Анимации
---
# Анимации

#### мотивация

Современные веб-компоненты часто используют анимацию. Каскадные стилисты (CSS) разрабатывают инструменты для создания впечатляющих анимаций. С помощью CSS возможны переходы свойств, уникальные анимации, многочастные ключевые кадры. Благодаря использованию CSS анимационные возможности бесконечны.

В современном веб-приложении анимация фокусирует внимание пользователя. Хорошая анимация направлена ​​на то, чтобы привлечь внимание пользователя в удовлетворительной, продуктивной манере. Анимации не должны раздражать пользователя.

Анимация предлагает обратную связь в виде движения. Они показывают пользователю, что приложение активно обрабатывает свои запросы. Что-то такое же простое, как нажатие на кнопку или загрузчик, когда приложение загружается, привлекает внимание пользователя.

Анимация продолжает становиться все более актуальной в случае Углового. Google развивает Angular, продвигая философию дизайна материалов. Он поощряет сжатые пользовательские интерфейсы (UI), дополненные анимированной обратной связью пользователей. Это заставляет веб-приложения чувствовать себя несколько живыми и забавными в использовании.

Угловое сообщество разрабатывает основную библиотеку виджетов под названием [Material2](https://github.com/angular/material2) . Этот проект добавляет множество модулей виджетов в Angular. Большинство из них имеют анимацию. Чтобы понять, как они работают, в этой статье рекомендуется изучить анимацию CSS перед чтением.

Угловая анимация - это рационализированная версия рамки того, что изначально предоставляет CSS. CSS - это основная технология для угловых анимаций, происходящих в веб-браузере. Однако CSS выходит за рамки этой статьи. Его время для борьбы с угловой анимацией в лоб.

#### Настройка анимаций

Перед анимацией `BrowserAnimationsModule` необходимо включать в массив импорта корневого модуля. Он доступен из `@angular/platform-browser/animations` . Этот NgModule обеспечивает работу анимации для данной платформы. Эта статья предполагает стандартный веб-браузер для каждого примера.

Угловая анимация объявляется в метаданных `@Component` . `@Component` украшает класс, чтобы отличить его как компонент от углового. Его метаданные содержат конфигурации компонентов, включая поле `animations: []` . Каждый элемент массива из этого поля представляет триггер анимации ( `AnimationTriggerMetadata` ).

Анимации являются эксклюзивными для компонента-хозяина через метаданные декоратора. Анимация может использоваться только в шаблоне хост-компонента. Анимации не наследуются к дочерним компонентам. Для этого есть легкая работа.

Вы всегда можете создать отдельный файл, который экспортирует массив. Любой класс компонента может импортировать этот массив из верхней части его файла хоста. Затем импортированный маркер массива переходит в метаданные анимации компонента. Повторите этот процесс для любых других компонентов, требующих одного и того же массива в метаданных анимации.

Проецирование контента позволяет применять анимацию к компоненту DOM компонента (Document Object Model). Компонент B, обертывающий это содержимое, DOM может проецировать содержимое в собственный шаблон. Как только это произойдет, анимация компонента A не отменяет. Компонент B включает анимацию A через контентную проекцию.

ОК. Вы знаете, как настроить анимацию и где ее объявлять. Реализация - следующий шаг.

#### Анимационные методы

Угловая анимация использует серию вызовов методов, импортируемых из `@angular/animations` . Каждый элемент `@Component` анимаций `@Component` начинается как один метод. Его аргументы распутываются как последовательность вызовов метода более высокого порядка. В следующем списке показаны некоторые методы, используемые для создания угловых анимаций.

*   `trigger(selector: string, AnimationMetadata[])`

возвращает `AnimationTriggerMetadata`

*   `state(data: string, AnimationStyleMetadata, options?: object)`

возвращает `AnimationStateMetadata`

*   `style(CSSKeyValues: object)`

возвращает `AnimationStyleMetadata`

*   `animate(timing: string|number, AnimationStyleMetadata|KeyframesMetadata)`

возвращает `AnimationAnimateMetadata`

*   `transition(stateChange: string, AnimationMetadata|AnimationMetadata[], options?: object)`

возвращает `AnimationTransitionMetadata`

Хотя есть, конечно, [больше методов](https://angular.io/api/animations) для выбора, эти пять методов обрабатывают основы. Попытка понять эти основные методы как список не очень помогает. Объяснения по пуле за пулями, сопровождаемые примером, будут лучше понимать это.

##### trigger (селектор: строка, AnimationMetadata \[\])

Метод `trigger(...)` инкапсулирует один элемент анимации внутри массива анимаций.

Первый аргумент метода `selector: string` соответствует `[@selector]` члена `[@selector]` . Он действует как директива атрибута в шаблоне компонента. Он по существу соединяет элемент анимации с шаблоном через селектор атрибутов.

Второй аргумент - это массив, содержащий список применимых методов анимации. `trigger(...)` сохраняет его в одном массиве.

##### state (data: string, AnimationStyleMetadata, options ?: object)

Метод `state(...)` определяет конечное состояние анимации. Он применяет список свойств CSS к целевому элементу после завершения анимации. Это значит, что CSS анимированного элемента соответствует разрешению анимации.

Первый аргумент соответствует значению данных, привязанных к привязке анимации. То есть значение, связанное с `[@selector]` в шаблоне, соответствует первому аргументу `state(...)` . Значение данных определяет конечное состояние. Изменение значения определяет средства анимации (см. `transition(...)` ).

Второй аргумент содержит стили CSS, которые применяются к элементу post-animation. Стили передаются путем вызова `style(...)` и передачи в свой аргумент желаемых стилей в качестве объекта.

Список опций, возможно, занимает третий аргумент. Параметры `state(...)` умолчанию `state(...)` должны оставаться неизменными, если не указано иное.

##### style (CSSKeyValues: объект)

Возможно, вы видели `AnimationStyleMetadata` несколько раз в предыдущем списке. Компонент `style(...)` возвращает этот точный тип метаданных. Где бы ни применялись стили CSS, должен быть вызван метод `style(...)` . Объект, содержащий стили CSS, стоит для своего аргумента.

Конечно, стили, аниматируемые в CSS, переносятся в метод Angular `style(...)` . Разумеется, ничто невозможное для CSS становится неожиданным возможным с Угловой анимацией.

##### animate (timing: string | number, AnimationStyleMetadata | AnimationKeyframesMetadata)

Функция `animate(...)` принимает выражение синхронизации в качестве своего первого аргумента. Этот аргумент времени, шагов и / или задерживает анимацию метода. Этот аргумент принимает либо числовое, либо строковое выражение. Форматирование объясняется [здесь](https://angular.io/api/animations/animate#usage) .

Второй аргумент `animate(...)` - это свойство CSS, гарантирующее анимацию. Это принимает форму метода `style(...)` который возвращает `AnimationStyleMetadata` . Подумайте о `animate(...)` в качестве метода, который инициирует анимацию.

Ряд ключевых кадров также может применяться ко второму аргументу. Ключевые кадры - это более продвинутый вариант, описанный в этой статье позже. Ключевые кадры различают различные разделы анимации.

`animate(...)` не может принимать второй аргумент. В этом случае время анимации метода применяется только к CSS, отраженному в методах `state(...)` . Изменения свойств в `state(...)` триггера `state(...)` будут анимированы.

##### переход (changExpr: string, AnimationMetadata | AnimationMetadata \[\], options ?: объект)

`animate(...)` инициирует анимацию, а `transition(...)` определяет, какая анимация инициируется.

Первый аргумент состоит из уникальной формы микросинтакса. Он обозначает изменение состояния (или изменения данных). Данные, привязанные к привязке анимации шаблона ( `[selector]="value"` ), определяют это выражение. Следующий раздел под названием «Состояние анимации» объясняет эту концепцию немного дальше.

Второй аргумент `transition(...)` содержит `AnimationMetadata` (возвращается `AnimationMetadata` `animate(...)` ). Аргумент принимает либо массив `AnimationMetadata` либо один экземпляр.

Значение первого аргумента совпадает со значением данных, связанным в шаблоне ( `[selector]="value"` ). Если происходит идеальное совпадение, аргумент успешно оценивается. Второй аргумент затем инициирует анимацию в ответ на успех первого.

Список опций, возможно, занимает третий аргумент. Параметры `transition(...)` умолчанию `transition(...)` должны оставаться неизменными, если не указано иное.

##### Пример анимации

```typescript
import { Component, OnInit } from '@angular/core'; 
 import { trigger, state, style, animate, transition } from '@angular/animations'; 
 
 @Component({ 
  selector: 'app-example', 
  template: ` 
  <h3>Click the button to change its color!</h3> 
  <button (click)="toggleIsCorrect()"     // event binding 
    [@toggleClick]="isGreen">Toggle Me!</button>  // animation binding 
    `, 
    animations: [       // metadata array 
      trigger('toggleClick', [     // trigger block 
      state('true', style({      // final CSS following animation 
        backgroundColor: 'green' 
      })), 
      state('false', style({ 
        backgroundColor: 'red' 
      })), 
      transition('true => false', animate('1000ms linear')),  // animation timing 
      transition('false => true', animate('1000ms linear')) 
    ]) 
  ]        // end of trigger block 
 }) 
 export class ExampleComponent { 
  isGreen: string = 'true'; 
 
  toggleIsCorrect() { 
    this.isGreen = this.isGreen === 'true' ? 'false' : 'true'; // change in data-bound value 
  } 
 } 
```

В приведенном выше примере выполняется очень простая замена цвета при каждом нажатии кнопки. Конечно, цвет быстро переходит в линейное затухание в соответствии с `animate('1000ms linear')` . Анимация привязывается к кнопке, сопоставляя первый аргумент `trigger(...)` с `[@toggleClick]` анимации `[@toggleClick]` .

Связывание связывается со значением `isGreen` из класса компонента. Это значение определяет результирующий цвет, заданный двумя методами `style(...)` внутри блока `trigger(...)` . Связывание анимации одностороннее, так что изменения в `isGreen` в классе компонента уведомляют привязку шаблона. То есть привязка анимации `[@toggleClick]` .

Элемент кнопки в шаблоне также связан с событием `click` . Нажатие кнопки приводит к тому, что `isGreen` переключает значения. Это изменяет данные класса компонента. Связывание анимации подхватывает это и вызывает его соответствующий метод `trigger(...)` . `trigger(...)` находится внутри массива анимаций метаданных компонента. При вызове триггера возникают две вещи.

Первое появление касается двух `state(...)` методов. Новое значение `isGreen` соответствует первому аргументу метода `state(...)` . После его соответствия стили CSS `style(...)` применяются к окончательному состоянию элемента хоста привязки анимации. \`Окончательное состояние вступает в силу после всей анимации.

Теперь для второго появления. Изменение данных, вызвавшее привязку анимации, сравнивается по двум методам `transition(...)` . Один из них соответствует изменению данных в их первом аргументе. Первый щелчок кнопки вызвал `isGreen` чтобы перейти от «true» к «false» («true => false»). Это означает, что первый метод `transition(...)` активирует второй аргумент.

`animate(...)` функция, соответствующая успешно пройденному методу `transition(...)` инициирует. Этот метод устанавливает длительность анимированного цветового эффекта, а также стимуляцию затухания. Анимация выполняется, и кнопка исчезает до красного цвета.

Этот процесс может произойти любое количество раз после нажатия кнопки. `backgroundColor` цвет кнопки будет циклически переключаться между зеленым и красным в линейном затухании.

#### Анимационное состояние

Микро-синтаксис `transition(...)` стоит подробно рассмотреть. Угловая определяет анимации и их время, оценивая этот синтаксис. Существуют следующие состояния переходов. Они моделируют изменения данных, привязанных к привязке анимации.

*   `'someValue' => 'anotherValue'`

Триггер анимации, где связанные данные изменяются с 'someValue' на 'anotherValue'.

*   `'anotherValue' => 'someValue'`

Триггер анимации, где связанные данные изменяются с 'anotherValue' на 'someValue'.

*   `'someValue' <=> 'anotherValue'`

Данные изменяются с 'someValue\` на' anotherValue 'или наоборот.

Существует также `void` и `*` состояние. `void` указывает, что компонент либо входит, либо выходит из DOM. Это идеально подходит для анимации входа и выхода.

*   `'someValue' => void` : хост-компонент связанных данных выходит _из_ DOM
    
*   `void => 'someValue'` : хост-компонент связанных данных _входит_ в DOM
    

`*` обозначает состояние подстановки. Подстановочные состояния могут интерпретироваться как «любое состояние». Это включает в себя `void` плюс любое другое изменение связанных данных.

#### Keyframes

В этой статье были затронуты основы анимации угловых приложений. Рядом с этими основами существуют усовершенствованные методы анимации. Группировка ключевых кадров - одна из таких методик. Его вдохновило `@keyframes` CSS `@keyframes` . Если вы работали с CSS `@keyframes` , вы уже понимаете, как работают ключевые кадры в работе «Угловая». Это просто вопрос синтаксиса

Метод `keyframes(...)` импортирует из `@angular/animations` . Он переходит во второй аргумент `animate(...)` вместо типичного `AnimationStyleMetadata` . Метод `keyframes(...)` принимает один аргумент как массив `AnimationStyleMetadata` . Это также можно назвать массивом методов `style(...)` .

Каждый ключевой кадр анимации входит в массив `keyframes(...)` . Этими ключевыми элементами являются методы `style(...)` поддерживающие свойство `offset` . `offset` указывает точку в продолжительности анимации, где должны применяться ее свойства стиля. Его значение составляет от 0 (начало анимации) до 1 (конец анимации).

```typescript
import { Component } from '@angular/core'; 
 import { trigger, state, style, animate, transition, keyframes } from '@angular/animations'; 
 
 @Component({ 
  selector: 'app-example', 
  styles: [ 
    `.ball { 
      position: relative; 
      background-color: black; 
      border-radius: 50%; 
      top: 200px; 
      height: 25px; 
      width: 25px; 
    }` 
  ], 
  template: ` 
  <h3>Arcing Ball Animation</h3> 
  <button (click)="toggleBounce()">Arc the Ball!</button> 
  <div [@animateArc]="arc" class="ball"></div> 
  `, 
  animations: [ 
    trigger('animateArc', [ 
      state('true', style({ 
        left: '400px', 
        top: '200px' 
      })), 
      state('false', style({ 
        left: '0', 
        top: '200px' 
      })), 
      transition('false => true', animate('1000ms linear', keyframes([ 
        style({ left: '0',     top: '200px', offset: 0 }), 
        style({ left: '200px', top: '100px', offset: 0.50 }), 
        style({ left: '400px', top: '200px', offset: 1 }) 
      ]))), 
      transition('true => false', animate('1000ms linear', keyframes([ 
        style({ left: '400px', top: '200px', offset: 0 }), 
        style({ left: '200px', top: '100px', offset: 0.50 }), 
        style({ left: '0',     top: '200px', offset: 1 }) 
      ]))) 
    ]) 
  ] 
 }) 
 export class ExampleComponent { 
  arc: string = 'false'; 
 
  toggleBounce(){ 
    this.arc = this.arc === 'false' ? 'true' : 'false'; 
  } 
 } 
```

Основное отличие приведенного выше примера по сравнению с другим примером - второй аргумент `animate(...)` . Теперь он содержит `keyframes(...)` метод размещения массива ключевых кадров анимации. В то время как сама анимация также отличается, метод анимации аналогичен.

Нажатие кнопки приводит к тому, что кнопка пересекает экран. Дуга перемещается в соответствии с элементами массива `keyframes(...)` (ключевыми кадрами). В средней точке анимации ( `offset: 0.50` ) мяч меняет траекторию. Он опускается до своей первоначальной высоты, когда он продолжается по экрану. При повторном нажатии этой кнопки анимация меняется.

`left` и `top` - анимационные свойства после установки `position: relative;` для элемента. Свойство `transform` может выполнять аналогичные анимации движения. `transform` - это экспансивное, но полностью анимативное свойство.

Любое количество ключевых кадров может существовать между смещением 0 и 1. Сложные последовательности анимации принимают форму ключевых кадров. Они являются одним из многих передовых методов в Angular анимации.

### Анимации с привязкой к хосту

Вы, несомненно, столкнетесь с ситуацией, когда вы хотите прикрепить анимацию к элементу HTML самого компонента, а не к элементу в шаблоне компонента. Это требует немного больших усилий, так как вы не можете просто войти в шаблон HTML и прикрепить туда анимацию. Вместо этого вам придется импортировать `HostBinding` и использовать это.

Минимальный код для этого сценария показан ниже. Я буду повторно использовать те же условия анимации для вышеприведенного кода для согласованности, и я не показываю никакого реального кода анимации, так как вы можете легко найти это выше.

```typescript
import { Component, HostBinding } from '@angular/core'; 
 
 @Component({ 
 ... 
 }) 
 export class ExampleComponent { 
  @HostBinding('@animateArc') get arcAnimation() { 
    return this.arc; 
  } 
 } 
```

Идея анимации хост-компонента в значительной степени аналогична анимированию элемента из шаблона, с той лишь разницей, что вам не хватает доступа к элементу, который вы анимации. Вы должны передать имя анимации ( `@animateArc` ) при объявлении `HostBinding` и вам все равно придется возвращать текущее состояние анимации ( `this.arc` ). Имя функции не актуально, поэтому `arcAnimation` можно было бы изменить на что угодно, если она не сталкивается с существующими именами свойств в компоненте, и это будет работать отлично.

#### Вывод

Это охватывает основы анимации с помощью Angular. Угловая конструкция упрощает настройку анимации с помощью Angular CLI. При первом запуске анимации требуется только один компонентный класс. Помните, что анимация распространяется на шаблон компонента. Экспортируйте свой массив переходов из отдельного файла, если вы планируете использовать его для нескольких компонентов.

Каждая утилита / метод анимации экспортируется из `@angular/animations` . Все они работают вместе, чтобы обеспечить надежную систему анимации, вдохновленную CSS. Существует больше методов, помимо того, что может охватывать эта статья.

Теперь, когда вы знаете основы, не стесняйтесь исследовать приведенные ниже ссылки для получения дополнительной информации об Угловой анимации.

## источники

*   [Угловая команда. «Анимация». _Google_ . Доступ к 7 июня 2018 года.](https://angular.io/guide/animations)
*   [Угловая команда. «Анимационный пакет». _Google_ . Доступ к 7 июня 2018 года.](https://angular.io/api/animations)

## Ресурсы

*   [Угловая документация](https://angular.io/guide)
*   [Угловая анимация](https://angular.io/guide/animations)
*   [API угловой анимации](https://angular.io/api/animations)
*   [Угловой репозиторий GitHub](https://github.com/angular/angular)
*   [Угловая CLI](https://cli.angular.io)
