---
title: Bash
localeTitle: удар
---
## Что такое Баш?

Bash (сокращение от Bourne Again SHell) - это оболочка Unix и интерпретатор командного языка. Оболочка - это просто макропроцессор, который выполняет команды. Это наиболее широко используемая оболочка, упакованная по умолчанию для большинства дистрибутивов Linux, и преемник оболочки Korn (ksh) и оболочки C (csh).

Многие вещи, которые можно сделать, можно использовать в операционной системе Linux. Некоторые примеры ...

*   Редактирование файлов
*   Регулировка громкости операционной системы
*   Получение веб-страниц из Интернета
*   Автоматическая работа, которую вы делаете каждый день

Вы можете узнать больше о bash [здесь](https://www.gnu.org/software/bash/) , через [Документацию GNU](https://www.gnu.org/software/bash/manual/html_node/index.html#SEC_Contents) и через руководство [tldp](http://tldp.org/HOWTO/Bash-Prog-Intro-HOWTO.html#toc10) .

## Использование bash в командной строке (Linux, OS X)

Вы можете начать использовать bash для большинства операционных систем Linux и OS X, открыв терминал. Рассмотрим простой пример приветствия. Откройте свой терминал и напишите следующую строку (все после знака $):
```
zach@marigold:~$ echo "Hello world!" 
 Hello world! 
```

Как вы можете видеть, мы использовали команду echo для печати строки «Hello world!». к терминалу.

## Написание сценария bash

Вы также можете поместить все ваши команды bash в файл .sh и запустить их из командной строки. Скажем, у вас был скрипт bash со следующим содержимым:
```
#!/bin/bash 
 echo "Hello world!" 
```

Стоит отметить, что первая строка скрипта начинается с `#!` , Это специальная директива, которую Unix рассматривает по-разному.

#### Почему мы использовали #! / Bin / bash в начале файла сценария?

Это потому, что это соглашение позволяет интерактивной оболочке знать, какой интерпретатор запускается для следующей программы. Первая строка сообщает Unix, что файл должен быть выполнен / bin / bash. Это стандартное расположение оболочки Bourne практически для каждой системы Unix. Добавив #! / Bin / bash в качестве первой строки вашего скрипта, он сообщает ОС, чтобы вызвать указанную оболочку для выполнения команд, которые следуют в скрипте. `#!` часто упоминается как «хеширование», «she-bang» или «sha-bang». Хотя он выполняется только в том случае, если вы запускаете свой скрипт как исполняемый файл. Например, когда вы `./scriptname.extension` , он будет искать верхнюю строку, чтобы узнать интерпретатор, тогда как при запуске скрипта как `bash scriptname.sh` первая строка игнорируется.

Затем вы можете запустить скрипт следующим образом: Для исполняемого файла make вы должны вызвать эту команду в sudo chmod + x "filename".
```
zach@marigold:~$ ./myBashScript.sh 
 Hello world! 
```

Сценарий имеет только две строки. Первый указывает, какой интерпретатор должен использовать для запуска файла (в данном случае bash). Вторая строка - это команда, которую мы хотим использовать, echo, за которой следует то, что мы хотим напечатать, это «Hello World».

Иногда сценарий не будет выполнен, и приведенная выше команда вернет ошибку. Это связано с правами, установленными в файле. Чтобы избежать этого:
```
zach@marigold:~$ chmod u+x myBashScript.sh 
```

\` А затем выполните скрипт.

### Дополнительная информация:

*   Википедия: https://en.wikipedia.org/wiki/Bash _(_ оболочка _Unix_ )
*   tldp.org Руководство по Bash: http://tldp.org/HOWTO/Bash-Prog-Intro-HOWTO.html#toc2
*   gnu.org Руководство пользователя Bash: https://www.gnu.org/software/bash/manual/html _node / index.html # SEC_ Содержание
*   Учебник по сценарию оболочки для начала работы: https://www.shellscript.sh/