---
title: Features of BlockTech
localeTitle: Особенности BlockTech
---
## Особенности технологии Blockchain

Blockchain почти всегда используется вместо биткойнов и криптовалюты. Тем не менее, есть много других мест, в которых эта технология может быть использована. И мы начинаем едва поцарапать его поверхность. Со всей шумихой вокруг него мы знаем, что Blockchain Technology (BlockTech) будет огромной. Но что делает его уникальным?

В этой статье мы рассмотрим ключевые особенности BlockTech.

#### _\* Децентрализованная система_

> Blockchain - это децентрализованная технология по дизайну.

Когда что-то контролируется центральной властью, где власть принимать решение лежит в руках вершины управления, такая система называется централизованной системой. Банки, например, представляют собой централизованную систему, в которой губернатор несет ответственность за принятие решений.

Напротив, когда власть возлагается на людей или пользователей, такая система считается децентрализованной системой. Одноранговая сеть Torrent, например, представляет собой децентрализованную систему, в которой пользователь имеет полный контроль.

![Децентрализованные системы](https://raw.githubusercontent.com/Vagisha16/Hw3/master/blockchain_article_pic.jpg)

#### _\* Распределенная книга_

> Блок-цепи используют распределенную технологию Ledger (DLT) для хранения и доступа к данным.

Когда что-то хранится в Распределенной книге, несколько копий ее выполняются по сети одновременно. В отличие от традиционных баз данных, распределенный регистр не имеет центральной базы данных или функций администрирования.

![Распределенная книга](https://qph.fs.quoracdn.net/main-qimg-2e24c4949a63eefa9bbab1773e185cdd)

При применении в децентрализованной системе, такой как Blockchain, каждый пользователь имеет копию книги и участвует в проверке транзакции. Это дает Blockchain свойство неизменности и обеспечивает безопасность. Поскольку данные распределены, отсутствует централизованная версия данных для взлома хакеров. Данные и записи являются общедоступными и легко проверяемыми. Это также устраняет одну точку отказа.

#### _\* Безопасная экосистема (криптографическое хеширование)_

BlockTech использует концепции, такие как «Доказательство работы» и «Хэш-шифрование» для обеспечения безопасности и неизменности. Доказательство работы включает в себя несколько человек во всем мире, используя вычислительный алгоритм, чтобы попытаться найти соответствующее значение хэша, которое удовлетворяет предопределенному условию относительно хэш-значения.

![хеширования](https://raw.githubusercontent.com/Vagisha16/Hw3/master/Hash.png)

![Доказательство работы](https://qph.fs.quoracdn.net/main-qimg-098a67b40e4d0f625cf2cbbda2c95df0)

#### _\* Добыча полезных ископаемых_

Torrent - это децентрализованная сеть одноранговой сети, используемая для обмена файлами. BlockTech использует подобную технологию. Что отличает пользователей от того, что в Torrent система использует код чести пользователей для посева файлов. Принимая во внимание, что в блокчейне пользователи, участвующие в транзакции, имеют экономические стимулы. Эти пользователи называются «Шахтеры». Шахтеры проводят свои вычислительные ресурсы для решения криптографических хэшей и обеспечения неизменности и надежности транзакции. Каждое успешное решение (дешифрование) обеспечивает экономическую выгоду.

![Добыча полезных ископаемых](https://raw.githubusercontent.com/Vagisha16/Hw3/master/5f6609014470f4b0122de37eb09dbfc7.jpg)

#### _\* Хронологическое и Time stamped_

Blockchains, в идеале, являются очень сложными связанными списками, где каждый блок представляет собой хранилище, в котором хранится информация, относящаяся к транзакции, а также ссылки на предыдущий блок в той же транзакции. Эти блоки упорядочены по порядку и во время создания имеют отметки времени, чтобы обеспечить справедливую запись.

#### _\* Консенсус_

Consensus Based - это подход к принятию решений. Это творческий и динамичный способ достижения согласия между всеми членами группы. Сделка по Blockchain может быть выполнена только в том случае, если все стороны в сети единогласно одобряют ее. Однако он подвергается изменениям в соответствии с различными обстоятельствами.

### источники

1.  [Распределенная книга](https://searchcio.techtarget.com/definition/distributed-ledger)
2.  [Что такое посев](http://help.utorrent.com/customer/portal/articles/164656)
3.  [Механизм согласования](https://www.seedsforchange.org.uk/consensus)
4.  [Основные особенности Blockchain](https://cryptocurry.com/news/top-4-major-features-blockchain/)
5.  [Применение и особенности Blockchain](https://arxiv.org/pdf/1806.03693.pdf)