---
title: Blockchain
localeTitle: блок цепи
---
## Blockchain

> «Является децентрализованной базой данных, в которой хранится реестр активов и транзакций в одноранговой сети. Является в основном публичным реестром того, кто владеет тем, кто и что совершает. Транзакции защищены криптографией и со временем эта история транзакций блокируется в блоках данных, которые затем криптографически связаны друг с другом и обеспечены. Это создает непреложную, незаменимую запись всех транзакций в этой сети. Эта запись реплицируется на каждом компьютере, использующем сеть ».
> 
> \--Беттина Варбург 1

Blockchain часто ассоциируется с биткойнами и другими криптоконвертами, но это не одно и то же. Биткойн был первым, кто реализовал концепцию Blockchain. Структура blockchain, растущий список записей, может быть применена ко многим другим областям, таким как цифровая идентичность, цепочка поставок и даже [демократия](https://www.democracy.earth/) .

Несмотря на то, что блок-цепь может применяться к большому количеству проблем, это не решение всего. Эта технология обычно используется для решения проблем, когда части не доверяют друг другу.

Третья сторона обычно необходима для проверки доверительных отношений. В наиболее распространенном примере, который является банковской системой, необходим доверенный орган, такой как банк, для промежуточных транзакций, управления счетами, проверки остатков и подтверждения перевода. Затем Blockchain приходит в этом случае, чтобы заменить регулирующий орган. В случае криптоконверсий он заменяет цифру банка, выполняет все проверки и гарантирует безопасность и достоверность транзакций.

По этой причине Blockchain также известен как **«Протокол доверия»** .

### История

Первая работа над криптографически защищенной цепочкой блоков была описана в 1991 году Стюартом Хабером и У. Скоттом Сторнеттой. Они хотели внедрить систему, в которой временные метки документов нельзя было подделать или заново использовать. В 1992 году Bayer, Haber и Stornetta включили деревья Merkle в проект, что позволило повысить его эффективность, позволив собрать несколько документов в один блок.

Первый блокчейн был концептуализирован человеком (или группой людей), известным как Сатоши Накамото в 2008 году. Он был реализован в следующем году Накамото в качестве основного компонента криптовалютной биткойны, где он служит в качестве публичной книги для всех транзакций на сеть.

В августе 2014 года размер файла биткойн-блокчейн, содержащий записи обо всех транзакциях, произошедших в сети, достиг 20 ГБ (гигабайт). В январе 2015 года размер вырос до почти 30 Гбайт, а с января 2016 года по январь 2017 года биткойн-блокчейн вырос с 50 до 100 ГБ. Кроме того, Накамото представил концепцию доказательства работы, чтобы обеспечить более децентрализованное доверие к безопасности записей.

Блок слов и цепочка слов были использованы отдельно в оригинальной работе Сатоши Накамото, но к 2016 году были в конечном итоге популяризированы как одно слово, блокчейн. Термин blockchain 2.0 относится к новым приложениям распределенной базы данных блокностей, впервые появившейся в 2014 году. Одна реализация этой программируемой блок-цепи второго поколения происходит с «языком программирования», который позволяет пользователям писать более сложные интеллектуальные контракты, тем самым создавая счета-фактуры, которые оплачивают себя, когда приходит прибытие или обмениваются сертификатами, которые автоматически отправляют их владельцам дивиденды, если прибыль достигает определенного уровня.

По состоянию на 2016 год реализация blockchain 2.0 по-прежнему требует, чтобы оракул без привязки к каким-либо «внешним данным или событиям, основанным на времени или рыночных условиях, взаимодействовал с блочной цепочкой».
Активно продвигается на рынке услуг.

#### Источники

1.  [Беттина Варбург: «Как радикальная кардинальная трансформация экономики», _TED Talks_ , 8 декабря 2016 года](https://youtu.be/RplnSVTzvnU?t=213)

##### Больше информации

*   [WTF является блочной цепью?](https://hackernoon.com/wtf-is-the-blockchain-1da89ba19348)
*   [Blockchain: революция, на которую мы не готовы](https://medium.freecodecamp.org/blockchain-is-our-first-22nd-century-technology-d4ad45fca2ce)
*   [Как блочная цепь меняет деньги и бизнес | Дон Тапскотт (видео на YouTube)](https://www.youtube.com/watch?v=Pl8OlkkwRpc)
*   [Введение в биткойн, Ethereum и смарт-контракты](https://github.com/WizardOfAus/WizardsEthereumWorkshop)
*   [Учебные статьи Blockchain](https://github.com/decrypto-org/blockchain-papers)
*   [Ресурсы Blockchain](https://github.com/BlockchainDevs/CryptocurrencyAwesome/blob/master/README.md)
