---
title: Smart Contracts
localeTitle: Smart Contracts
---
## Смарт-контракты

### Принцип работы
Стороны подписывают умный контракт, используя методы, аналогичные подписанию отправки средств в действующих криптовалютных сетях. После подписания сторонами контракт вступает в силу. Для обеспечения автоматизированного исполнения обязательств контракта непременно требуется среда существования, которая позволяет полностью автоматизировать выполнение пунктов контракта. Это означает, что умные контракты смогут существовать только внутри среды, имеющей беспрепятственный доступ исполняемого кода к объектам умного контракта. Все условия контракта должны иметь математическое описание и ясную логику исполнения. В связи с этим первые умные контракты имеют задачу формализации наиболее простых взаимоотношений, состоящих из небольшого количества условий. Имея беспрепятственный доступ к объектам контракта, умный контракт отслеживает по указанным условиям достижения или нарушения пунктов и принимает самостоятельные решения, основываясь на запрограммированных условиях. Таким образом, основной принцип умного контракта состоит в полной автоматизации и достоверности исполнения договорных отношений.

### История
Первые идеи умных контрактов были предложены в 1994 году Ником Сабо. Практические реализации стали возможными, благодаря появлению в 2008 году технологии блокчейн. Некоторые принципы умных контрактов были заложены в протоколе первой блокчейн-валюты Bitcoin, однако они не были реализованы в клиентском программном обеспечении, не обладали полнотой по Тьюрингу из соображений безопасности и не использовались на практике. С появлением технологии, стали высказываться идеи, что поверх протокола биткойна могут быть созданы различные протоколы более высокого уровня, включая полноценные умные контракты, по аналогии с тем как поверх TCP/IP существуют множество протоколов прикладного уровня.

Умные контракты впервые начали применяться на практике в проекте Ethereum. Идея создания проекта появилась в 2013 году. В тот момент основатель журнала Bitcoin Magazine Виталик Бутерин пришёл к выводу, что технология блокчейна может использоваться значительно шире, не только в криптовалютах. Он выдвинул идею универсальной децентрализованной блокчейн-платформы, в которой любой желающий может программно реализовать разные системы хранения и обработки информации. Главное условие — действия должны быть описаны как математические правила[6].

### Объекты умного контракта
* **Подписанты** — стороны умного контракта, принимающие или отказывающиеся от условий с использованием электронных подписей. Прямым аналогом является подпись отправителя средств в сети Bitcoin, которая подтверждает внесение транзакции в цепочку блоков.
* **Предмет договора**. Предметом договора может являться только объект, находящийся внутри среды существования самого умного контракта, или же должен обеспечиваться беспрепятственный, прямой доступ умного контракта к предмету договора без участия человека. Это является наиболее сложным вопросом, который невозможно было решить до появления криптовалют в 2009 году.
* **Условия**. Условия умного контракта должны иметь полное математическое описание, которое возможно запрограммировать в среде существования умного контракта. Именно в условиях описывается логика исполнения пунктов предмета договора.
* **Децентрализованная платформа**. Для распределенного хранения смарт-контракта необходима его запись в Блокчейне этой платформы.

### Среда для работы умных контрактов
Для того, чтобы умные контракты могли существовать, требуются определённые условия:
1) Использование широко распространенных методов электронной подписи на основе публичных и приватных ключей (асимметричное шифрование).
2) Существование открытых, децентрализованных и доверительных сторонам контракта баз данных для исполняемых транзакций, работа которых полностью исключает человеческий фактор. Как пример: блокчейн в Bitcoin.
3) Децентрализация среды исполнения умного контракта. Как пример: Ethereum, Codius, Counterparty (англ.).
4) Достоверность источника цифровых данных. Как пример: корневые центры сертификации SSL в базах современных интернет-браузеров. 
