---
title: Buttons
localeTitle: Кнопки
---
## Кнопки


Библиотека Bootstrap предоставляет различные варианты для стилизации кнопок. Эти стили помогут вам дать пользователю визуальное представление о том, что каждая кнопка делает.

#### Как использовать:

Чтобы использовать кнопки из бибилиотеки Bootstrap вы выполняете те же шаги, что и при создании кнопки в HTML, за исключением того, что  вам также потребуется применить к кнопке соответствующий CSS класс. Пример кода приведен ниже.



**Пример кода:**

```html
<button type="button" class="btn btn-primary">Primary</button>
```

Также, вы можете использовать Bootstrap кнопки вместе с элементами `<a>` и `<input>`, как показано в приведенных ниже примерах.

```html
<a class="btn btn-primary" href="#" role="button">This button is a link</a>
```

[Эта кнопка является ссылкой](#)


```html
<input class="btn btn-primary" type="submit" value="Submit">
```

#### Bootstrap Button Список классов:

Это список классов CSS, которые бутстрап предусматривает для кнопок:

`.btn` Это базовая кнопка бутстрапа.

основной

`.btn-default` Это кнопка по умолчанию в бутстрапе.

По умолчанию

`.btn-primary` Это основная кнопка бутстрапа.

первичный

`.btn-success` Это кнопка успеха бутстрапа.

успех

`.btn-info` Это информационная кнопка бутстрапа.

Информация

`.btn-warning` Это кнопка предупреждения бутстрапа.

Предупреждение

`.btn-danger` Это кнопка опасности бутстрапа.

Опасность

`.btn-link` Это кнопка ссылки для загрузки.

Ссылка на сайт

`.btn-light` Это световая кнопка бутстрапа.

Свет

#### Размер кнопки загрузки:

Это список классов CSS для кнопок разного размера:

`.btn-lg` Это большая кнопка бутстрапа.

большой

`.btn-sm` Это маленькая кнопка бутстрапа.

Маленький

`.btn-xs` Это дополнительная маленькая кнопка бутстрапа.

Очень маленький

#### Бутстрап Очерченые кнопки:

Можно также очертить кнопки, а не полностью окрашивать их. Это достигается путем размещения `outline` в середину класса кнопки, которую вы хотите использовать. Пример использования будет следующим:

```html
<button type="button" class="btn btn-outline-primary">Primary</button>
```

Очерченые кнопки являются частью Bootstrap с версии 4, пожалуйста, убедитесь, что вы используете правильную версию, если вы не можете заставить их работать.

_Примечание. Не включайте точку в атрибуте класса HTML, ссылаясь на классы с точкой, используется только при настройке классов в CSS._

#### Дополнительная информация:

*   [Документация по кнопкам Bootstrap](https://getbootstrap.com/docs/4.0/components/buttons/)
*   [Бутстрап Кнопка Групповая документация](http://getbootstrap.com/docs/4.0/components/button-group/)
*   [Начальная загрузка](/articles/bootstrap/bootstrap-get-started)
