---
title: Bootstrap
localeTitle: начальная загрузка
---
## начальная загрузка

Bootstrap - популярная интерфейсная платформа для веб-разработки. Он содержит готовые компоненты и элементы дизайна для создания HTML-контента. Современные браузеры, такие как Chrome, Firefox, Opera, Safari и Internet Explorer, поддерживают Bootstrap.

Bootstrap включает в себя гибкую сетчатую систему для различных макетов. Это отличная отправная точка для создания мобильного сайта для мобильных устройств. Он также включает в себя дополнительные функции JavaScript, такие как складной контент, карусели и модалы.

#### История версий

Первоначально Twitter разработал структуру Bootstrap как внутренний инструмент. Они выпустили его в качестве проекта с открытым исходным кодом в августе 2011 года.

Bootstrap 2 был выпущен в январе 2012 года. Одной из основных особенностей стало введение 12-ти ответной сетчатой ​​системы. Bootstrap 3 появился в августе 2013 года, переключившись на плоский дизайн и мобильный подход. Bootstrap 4 доступен в бета-версии по состоянию на август 2017 года, а теперь включает Sass и Flexbox.

Bootstrap 4 разрабатывался в течение двух лет до выпуска некоторых бета-версий в течение 2017 года, а первый стабильный релиз вышел в январе 2018 года. Некоторые заметные изменения включают:

*   Перемещено от Меньшего до Сасса;
*   Перемещено в Flexbox и улучшена сетка;
*   Добавлены карты (замена колодцев, миниатюр и панелей);
*   И многое другое!

На момент написания последней версии Bootstrap был \[4.1.3\] (http://blog.getbootstrap.com/2018/07/24/bootstrap-4-1-3/ ). Если вы хотите идти в ногу с новостями об объявлениях, следуйте за ними [здесь](http://blog.getbootstrap.com/) .

#### Монтаж

Есть два основных варианта добавления Bootstrap в ваш веб-проект. Вы можете ссылаться на общедоступные источники или загружать фреймворк напрямую.

##### Связь с другим источником

Вы можете добавить Bootstrap CSS, используя элемент `<link>` внутри `<head>` вашей веб-страницы, который ссылается на сеть доставки контента (CDN):

`<link rel="stylesheet" href="http://192.168.109.2/resources/bootstrap-4.1.2/dist/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">`

Добавление элементов JavaScript в Bootstrap аналогично элементам `<script>` которые обычно помещаются внизу вашего ' ' тег. Возможно, вам придется сначала включить некоторые зависимости. Обратите особое внимание на указанный порядок:

```html

<script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script> 
 <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.3/umd/popper.min.js" integrity="sha384-ZMP7rVo3mIykV+2+9J3UJ46jBk0WLaUAdn689aCwoqbBJiSnjAK/l8WvCWPIPm49" crossorigin="anonymous"></script> 
 <script src="http://192.168.109.2/resources/bootstrap-4.1.2/dist/js/bootstrap.min.js" integrity="sha384-ChfqqxuZUCnJSK3+MXmPNIyE6ZbWh2IMqE241rYiqJxyMiZ6OW/JmZQ5stwEULTy" crossorigin="anonymous"></script> 
```

_Примечание. Это только примеры и могут быть изменены без предварительного уведомления. Пожалуйста, обратитесь к CDN для текущих ссылок, которые будут включены в ваш проект._

##### Скачать / Установить

Вы можете загружать и устанавливать исходные файлы Bootstrap с помощью Bower, Composer, Meteor или npm. Это позволяет повысить контроль и возможность включать или исключать модули по мере необходимости.

`npm install bootstrap`

`gem 'bootstrap', '~> 4.1.3'`

\_Примечание: Это только примеры и могут быть изменены без предварительного уведомления. Пожалуйста, обратитесь к [сайту](https://getbootstrap.com/) \_ [Bootstrap](https://getbootstrap.com/) \_ для самых последних ссылок.

#### Сетевая система Bootstrap

Сетчатая система представляет собой мобильную первую систему flexbox для быстрого построения макетов всех форм и размеров, подходящих для всех устройств. Он основан на раскладке из 12 столбцов и имеет несколько уровней, по одному для каждого диапазона запросов.

Bootstrap поставляется с предопределенными классами сетки для вашего использования в разметке. Более подробную информацию и примеры см. На странице https://getbootstrap.com/docs/4.1/layout/grid/.

### Особенности Boostrap

*   Bootstrap 3 поддерживает последние версии Google Chrome, Firefox, Internet Explorer, Opera и Safari (кроме Windows). Он также поддерживает поддержку IE8 и последней версии расширенной поддержки Firefox (ESR). \[12\]
    
*   Начиная с версии 2.0, Bootstrap поддерживает гибкий веб-дизайн. Это означает, что макет веб-страниц настраивается динамически, принимая во внимание характеристики используемого устройства (рабочий стол, планшет, мобильный телефон).
    
*   Начиная с версии 3.0, Bootstrap приняла философию дизайна мобильных устройств, подчеркнув, что дизайн по умолчанию отличается от адаптивного дизайна.
    
*   Версия 4.0 добавлена ​​поддержка Sass и flexbox
    

#### Дополнительная информация:

У Bootstrap есть полная документация со многими [примерами](https://getbootstrap.com/docs/4.0/examples/) и [шаблон HTML для начала работы](https://getbootstrap.com/docs/4.0/getting-started/introduction/) (этот шаблон содержит только скрипт, он не содержит настройки сетки, если это то, что вы ищете).

Кроме того, вы можете найти как [бесплатные, так](https://bootswatch.com/) и [оплачиваемые](https://themes.getbootstrap.com/) темы, которые основываются на структуре Bootstrap, чтобы обеспечить более индивидуальный и стильный внешний вид.

#### Ресурсы Bootstrap:

[Официальный блог Bootstrap](http://blog.getbootstrap.com/) [Исходное содержание сайта Bootstrap](http://expo.getbootstrap.com/) [Витрина сайтов, построенных с использованием Bootstrap](http://builtwithbootstrap.com/) [HTML linter для проектов с использованием Bootstrap](https://github.com/twbs/bootlint) [Элементы дизайна и фрагменты кода для Bootstrap](https://bootsnipp.com/) [Код, тема и дополнительные ресурсы для Bootstrap](http://expo.getbootstrap.com/resources/)