---
title: Data Types in C
localeTitle: Типы данных в C
---
# Типы данных в C

Существует несколько способов хранения данных на C, и они все уникальны друг от друга. Типы данных, которые могут быть сохранены в памяти, называются типами данных. C гораздо менее прощает типы данных, чем другие языки. В результате важно убедиться, что вы понимаете существующие типы данных, их возможности и их ограничения.

Одна из особенностей типов данных C заключается в том, что они полностью зависят от оборудования, на котором выполняется ваш код. `int` на вашем ноутбуке будет меньше, чем `int` на суперкомпьютере, поэтому важно знать ограничения оборудования, над которым вы работаете. Вот почему типы данных определяются как минимальные значения - значение `int` , как вы узнаете, составляет минимум от 32767 до 32767: на некоторых машинах он сможет хранить еще больше значений, которые это делают.

Есть две категории, которые мы можем разбить на: целые числа и числа с плавающей запятой. Целые числа - целые числа. Они могут быть положительными, отрицательными или нулевыми. Номера, такие как -321, 497, 19345 и -976812, являются вполне допустимыми целыми числами, но 4.5 не потому, что 4.5 не является целым числом.

Числа с плавающей запятой - это числа с десятичной точкой. Как и целые числа, значения -321, 497, 19345 и -976812 действительны, но теперь действуют 4.5, 0.0004, -324.984 и другие нецелые числа.

C позволяет нам выбирать между несколькими различными параметрами наши типы данных, потому что они все хранятся по-разному на компьютере. В результате важно знать о возможностях и ограничениях каждого типа данных, чтобы выбрать наиболее подходящий.

## Целочисленные типы данных

#### Персонажи: `char`

`char` содержит символы - такие вещи, как буквы, знаки препинания и пробелы. На компьютере символы хранятся в виде чисел, поэтому `char` хранит целочисленные значения, которые представляют символы. Фактический перевод описывается стандартом ASCII. [Вот](http://www.asciitable.com/) удобный стол для поиска.

Фактический размер, как и все другие типы данных в C, зависит от оборудования, над которым вы работаете. Как минимум, это не менее 8 бит, поэтому у вас будет по крайней мере от 0 до 127. В качестве альтернативы вы можете использовать `signed char` чтобы получить от -128 до 127.

#### Стандартные целые числа: `int`

Объем памяти, который принимает один `int` зависит от аппаратного обеспечения. Однако вы можете ожидать, что `int` будет иметь размер не менее 16 бит. Это означает, что он может хранить значения от -32,768 до 32,767 или более в зависимости от аппаратного обеспечения.

Как и все эти другие типы данных, существует `unsigned` вариант, который можно использовать. `unsigned int` может быть положительным и нулевым, но не отрицательным, поэтому он может хранить значения от 0 до 65535 или более в зависимости от аппаратного обеспечения.

#### Короткие целые числа: `short`

Это часто не используется, но хорошо знать, что он существует. Как и int, он может хранить -32768 до 32767. В отличие от int, однако, это степень его способности. В любом месте, где вы можете использовать `short` , вы можете использовать `int` .

#### Более длинные целые числа: `long`

`long` тип данных хранит целые числа, такие как `int` , но дает более широкий диапазон значений за счет увеличения объема памяти. Длинный хранит не менее 32 бит, что дает диапазон от -2,147,483,648 до 2,147,483,647. Альтернативно, используйте `unsigned long` для диапазона от 0 до 4 294 967 295.

#### Даже более длинные целые числа: `long long`

`long long` тип данных является излишним почти для каждого приложения, но C позволит вам использовать его в любом случае. Он способен хранить не менее -9,223,372,036,854,775,807 до 9,223,372,036,854,775,807. В качестве альтернативы, получите еще больше переполнения с `unsigned long long` , что даст вам по крайней мере от 0 до 18 446 744 073 709 551 615.

## Типы данных с плавающей точкой

#### Основные номера с плавающей запятой: `float`

`float` занимает не менее 32 бит для хранения, но дает нам 6 знаков после запятой от 1.2E-38 до 3.4E + 38.

#### `double`

`double` берет двойной объем памяти float (так минимум 64 бит). В свою очередь, double может обеспечить 15 десятичных знаков от 2.3E-308 до 1.7E + 308.

#### Получение более широкого диапазона удвоений: `long double`

`long double` занимает не менее 80 бит. В результате мы можем получить 19 десятичных знаков от 3.4E-4932 до 1.1E + 4932.

## Выбор правильного типа данных

C делает выбор типа данных и делает нас очень конкретными и преднамеренными в отношении того, как мы это делаем. Это дает вам большую власть над вашим кодом, но важно выбрать правильный.

В общем, вы должны выбрать минимум для своей задачи. Если вы знаете, что вы будете рассчитывать от целого числа от 1 до 10, вам не нужно долгое время, и вам не нужен двойной. Если вы знаете, что у вас никогда не будет отрицательных значений, изучите использование `unsigned` вариантов типов данных. Предоставляя эту функциональность, а не делая ее автоматически, C может создавать очень легкий и эффективный код. Тем не менее, вам решать, как программист понимать возможности и ограничения, и выбирать соответственно.

Мы можем использовать оператор sizeof () для проверки размера переменной. См. Следующую C-программу для использования различных типов данных:

```c
#include <stdio.h> 
 
 int main() 
 { 
    int a = 1; 
 
    char b ='G'; 
 
    double c = 3.14; 
 
    printf("Hello World!\n"); 
 
    //printing the variables defined above along with their sizes 
    printf("Hello! I am a character. My value is %c and " 
           "my size is %lu byte.\n", b,sizeof(char)); 
    //can use sizeof(b) above as well 
 
    printf("Hello! I am an integer. My value is %d and " 
           "my size is %lu  bytes.\n", a,sizeof(int)); 
    //can use sizeof(a) above as well 
 
    printf("Hello! I am a double floating point variable." 
           " My value is %lf and my size is %lu bytes.\n",c,sizeof(double)); 
    //can use sizeof(c) above as well 
 
    printf("Bye! See you soon. :)\n"); 
    return 0; 
 } 
```

## Вывод:

Привет, мир!  
Здравствуйте! Я персонаж. Мое значение - G, а мой размер - 1 байт.  
Здравствуйте! Я - целое число. Мое значение равно 1, а мой размер - 4 байта.  
Здравствуйте! Я - двойная переменная с плавающей запятой. Мое значение - 3,140000, а мой размер - 8 байт.  
До свидания! Скоро увидимся. :)

## Тип Void

Тип void указывает, что значение не доступно. Он используется в трех типах ситуаций:

#### 1\. Функция возвращается как пустота

В C есть различные функции, которые не возвращают никакого значения, или вы можете сказать, что они возвращают пустоту. Функция без возвращаемого значения имеет тип возврата как void. Например, `void exit (int status);`

#### 2\. Аргументы функции как недействительные

В C есть различные функции, которые не принимают никаких параметров. Функция без параметра может принимать пустоту. Например, `int rand(void);`

#### 3\. Указатели на пустоту

Указатель типа void \* представляет адрес объекта, но не его тип. Например, функция выделения памяти `void *malloc( size_t size);` возвращает указатель на void, который может быть передан любому типу данных.

# Прежде чем продолжить ...

## Обзор

*   Фактические возможности типов данных C зависят от аппаратного обеспечения. В результате для типов данных определяются минимальные размеры.
*   Числа с плавающей запятой позволят вам иметь десятичные числа, а целые числа - нет.
*   У нас есть некоторые варианты для наших целочисленных значений:
*   char, который предназначен для символов, но сохраняет номера
*   int, который является стандартным целым типом данных
*   короткий, который является менее используемым, но все еще доступным целым типом данных
*   long, что дает широкий диапазон целочисленных значений
*   длинный длинный, что дает диапазон избыточных значений целочисленных значений, но по-прежнему полезно.
*   У нас также есть некоторые опции для наших значений с плавающей запятой:
*   float - базовое значение с плавающей запятой, сохраняющее 6 знаков после запятой
*   double берет двойную память и дает 15 знаков после запятой
*   длинный двойной занимает еще больше памяти и дает 19 знаков после запятой
*   Выбор правильного типа данных важен и дает программисту большой контроль над программой на низком уровне.