---
title: For Loop
localeTitle: Для цикла
---
# Для цикла

Цикл `for` выполняет блок кода до тех пор, пока указанное условие не станет ложным. Используйте `while` когда число итераций является переменной, в противном случае используется `for` циклов. Обычное использование циклов `for` - это итерации массива.

## Синтаксис для цикла

```c
for ( init; condition; increment ) { 
   statement(s); 
 } 
```

Цикл `for` состоит из трех разделов, секции инициализации, конкретного условия и секции инкрементной или декрементной операции. Эти три секции управляют циклом `for` .

Оператор инициализации выполняется только один раз. Затем оценивается тестовое выражение. Если тестовое выражение ложно (0), цикл завершается. Но если тестовое выражение истинно (отличное от нуля), выполняются коды внутри тела цикла for и обновляется выражение update. Этот процесс повторяется до тех пор, пока тестовое выражение не станет ложным.

Цикл for обычно используется, когда число итераций известно.

## пример

```c
#include <stdio.h> 
 
 int main () { 
 
    int array[] = {1, 2, 3, 4, 5}; 
 
    for (int i = 0; i < 5; i++) { 
        printf("Item on index %d is %d\n", i, array[i]); 
    } 
 } 
```

## Вывод:

```shell
> Item on index 0 is 1 
 > Item on index 1 is 2 
 > Item on index 2 is 3 
 > Item on index 3 is 4 

```