---
title: Format Specifiers
localeTitle: Спецификаторы формата
---
# Спецификаторы формата

Спецификаторы формата определяют тип данных, которые должны быть напечатаны на стандартном выходе. Независимо от того, печатать форматированный вывод или принимать форматированный вход, нужны спецификаторы форматирования. Спецификаторы формата также называются форматированной строкой. Спецификатор форматов используется во время ввода и вывода. Это способ сообщить компилятору, какой тип данных находится в переменной во время ввода ввода с помощью scanf () или печати с помощью printf (). Некоторые примеры:% c,% d,% f и т. Д.

Спецификатор формата символа:% c

# включают

int main () { char ch = 'A'; printf ("% c \\ n", ch); return 0; }

Вывод:

Спецификатор целочисленного формата:% d,% i

# включают

int main () { int x = 45, y = 90; printf ("% d \\ n", x); printf ("% i \\ n", x); return 0; }

Вывод: 45 45

Спецификатор двойного формата:% f,% e или% E

# включают

int main () { float a = 12,67; printf ("% f \\ n", a); printf ("% e \\ n", a); return 0; }

Вывод: 12.670000 1.267000e + 01

Unsigned Octal number для целых чисел:% o

# включают

int main () { int a = 67; printf ("% o \\ n", a); return 0; }

Вывод: 103

Беззнаковое шестнадцатеричное для целого числа:% x,% X

# включают

int main () { int a = 15; printf ("% x \\ n", a); return 0; }

Вывод: е

Печать строк:% s

# включают

int main () { char a \[\] = "nitesh"; printf ("% s \\ n", a); return 0; }

Вывод: Nitesh

* * *

scanf (char \* format, arg1, arg2, ...)

десятичное целое число:% d

# включают

int main () { int a = 0; scanf ("% d", & a); // ввод 45 printf ("% d \\ n", a); return 0; }

вывод: 45

Целое число может быть восьмеричным или шестнадцатеричным:% i

# включают

int main () { int a = 0; scanf ("% i", & a); // ввод 017 (восьмеричный из 15) printf ("% d \\ n", a); scanf ("% i", & a); // ввод равен 0xf (шестнадцатеричный из 15) printf ("% d \\ n", a); return 0; }

вывод: 15 15

Тип данных с плавающей запятой:% f,% e (двойной),% lf (длинный двойной)

# включают

int main () { float a = 0.0; scanf ("% f", & a); // ввод 45.65 printf ("% f \\ n", a); return 0; }

Вывод: 0.000000

Строковый вход:% s

# включают

int main () { char str \[20\]; scanf ("% s", str); // ввод - это nitesh printf ("% s \\ n", str); return 0; }

Вывод: Nitesh

Ввод символов:% c

# включают

int main () { char ch; scanf ("% c", & ch); // ввод A printf ("% c \\ n", ch); return 0; }

вывод:

Спецификаторы%, которые можно использовать в ANSI C:

| Спецификатор | Используется для | |: -------------: |: -------------: | | % c | один символ | | % s | строка | | % Привет | короткий (подпись) | | % Ху | короткий (без знака) | | % Lf | длинный двойной | | % n | ничего не печатает | | % d | десятичное целое число | | % o | восьмеричное (основание 8) целое число | | % x | шестнадцатеричное (базовое 16) целое число | | % p | адрес (или указатель) | | % f | число с плавающей запятой для поплавков | | % u | int unsigned decimal | | % e | число с плавающей запятой в научной нотации | | % E | число с плавающей запятой в научной нотации | | %% | Символ! |