---
title: Functions
localeTitle: функции
---
# Функции в C

Иногда у вас есть кусок кода, который нужно использовать много раз, но в разное время и в вашем коде. Вы можете копировать и вставлять его снова и снова, но это не отличное решение. Размер вашего файла больше, ваш код сложнее отлаживать, а ваш код сложнее читать. Вместо этого используйте функцию: функции похожи на мини-программы, которые существуют внутри вашего кода. Вы можете передать им переменные для использования, и они могут вернуть данные.

## Пример

Вот простой пример функции, которая делит два числа. Это не очень полезно, так как у нас есть `/` , но он показывает разные части функции.

```C
#include <stdio.h> 
 
 int divides(int a, int b) { 
    return a / b; 
 } 
 
 int main(void) { 
    int first = 5; 
    int second = 10; //MUST NOT BE ZERO; 
 
    int result = divides(first, second); 
 
    printf("first divided by second is %i\n", result); 
 
    return 0; 
 } 
```

Обратите внимание, что как `main` , `divides` имеют аналогичный формат. Это потому, что `main` также является функцией - это просто особенность, потому что C сначала ищет ее. `divides` также происходит до `main` . Это важно, потому что `main` вызовы `divides` . Вызов функции означает, что ее код используется. Код должен быть скомпилирован до того, как он будет использоваться, а C скомпилирует строку за строкой сверху, поэтому для вызова функции она должна быть выписана до того, как она будет вызываться как в этом примере. Если `divides` произошло после `main` , это не получится, потому что компилятор не знает, что `divides` существуют. Вы также можете использовать прототип функции перед основным, чтобы вы могли поместить `divides` после основного. Прототип функции идентичен функции с теми же переменными и возвращаемым типом, за исключением того, что скобки опущены и заменены точкой с запятой:

```C
int divides(int a, int b); 
```

Также обратите внимание, что `divides` и `main` не разделяют скобки и не находятся в скобках друг друга. Они должны быть отдельными, даже если один называет другого.

Имея это в виду, перейдем к первой строке функции в следующем разделе, озаглавленном:

## Нарушение объявления функции

```C
int divides(int a, int b) 
```

Объявление функции начинается с типа данных, который в этом случае является `int` . Какой бы тип данных вы не хотели возвращать, вы должны поместить здесь. Вы можете вернуть любой тип данных, иначе он не может быть типом данных, поместив здесь `void` .

Далее следует имя функции. Всякий раз, когда вы хотите вызвать функцию, это имя, которое вы будете использовать. Попытайтесь сделать это чем-то описательным, чтобы вы могли легко определить, что он делает.

После названия появляется пара скобок. В этой скобке перечислены параметры нашей функции, которые являются переменными, которые эта функция будет использовать и использовать при запуске кода. В этом случае их два. Оба они являются типом данных `int` , и они будут называться `a` и `b` . В идеале, здесь лучше использовать имена, но вы обнаружите, что для простых и быстрых методов часто используются имена временных переменных.

Теперь давайте посмотрим, что находится внутри скобок:

```C
return a / b; 
```

Это довольно просто, потому что это такая простая функция. `a` делится на `b` , и это значение возвращается. Вы видели `return` раньше в `main` функции, но теперь вместо того, чтобы заканчивать нашу программу, она заканчивает метод и дает значение тому, что называется.

Итак, чтобы понять, что делает эта функция, она получает два целых числа, делит их и возвращает их тому, что называется.

### Параметры функции

Параметры используются для передачи аргументов функции. Это два типа параметров: Параметр, написанный в определении функции, называется «Формальный параметр». Параметр, написанный в вызове функции Вызывается «Фактический параметр». Они также известны как аргументы. Они передаются в определение функции, и копия создается в виде формальных параметров.

## Более сложный пример

Это одна функция линии. Вы увидите их, когда есть довольно простая операция, которая должна выполняться много раз, или операция, которая заканчивается одной длинной строкой. Сделав это функцией, код становится более читаемым и управляемым.

При этом большинство функций не будет одной строкой кода. Давайте посмотрим на другой, немного более сложный пример, который выбирает большее из двух чисел.

```C
int choose_bigger_int(int a, int b) { 
    if(a > b) 
        return a; 
 
    if(b > a) 
        return b; 
 
    return a; 
 } 
```

Как и раньше, функция возвращает целое число и принимает два целых числа. Ничего нового не видно.

Этот код начинается с утверждения , что если проверяет , если больше `a` `b` . В случае, если он есть, он вернет `a` . Если это будет сделано, функция закончится здесь - остальная часть кода не будет оценена. Однако, если этот оператор возврата не достигнут, будет вычисляться следующий оператор if. Если это так, `b` будет возвращено, и функция закончится здесь.

При этом учитывались условия для существа, большего, чем b, и b, превышающего a. Однако, если a равно b, функция все равно ничего не вернет. По этой причине мы возвращаем a (a равно b, поэтому мы можем вернуться либо).

## Слово «область»

Сфера действия - вещь, о которой нужно знать. Это относится к областям в вашем коде, где доступна переменная. Когда вы передаете переменную функции, функция получает свою собственную копию. Это означает, что настройка переменной в функции не будет регулировать ее где-либо еще. Аналогичным образом, если вы не передали переменную функции, она не имеет ее и не может ее использовать.

Возможно, вы наблюдали подобную проблему с такими вещами, как инструкции if и любой из циклов. Если вы объявите переменную в скобках, она не будет доступна за пределами этих скобок. Это верно для функций таким же образом, но есть некоторые способы обойти это:

*   Сделать глобальную переменную, объявив ее вне любых функций
*   Это делает ваш код более грязным и, как правило, не рекомендуется. Его следует избегать, когда это возможно
*   Используйте указатели, которые вы будете читать о следующем
*   Это может сделать ваш код более трудным для чтения и отладки
*   Переходите к своим функциям, как будто вы должны
*   Это лучший способ сделать это, если это вариант

В идеале вы всегда будете выполнять свои функции в качестве параметров, но вы не всегда сможете это сделать. Выбор лучшего решения - это ваша работа программиста.

Рекурсия в C Когда функция вызывается внутри одной и той же функции, она называется рекурсией в C. Функция, вызывающая ту же функцию, называется рекурсивной функцией.
```
int factorial (int n) 
 { 
    if ( n < 0) 
        return -1; /*Wrong value*/ 
    if (n == 0) 
        return 1; /*Terminating condition*/ 
    return (n * factorial (n -1)); 
 } 
```

# Прежде чем продолжить ...

## Обзор

*   Функции полезны для использования, потому что они делают ваш код более чистым и легким для отладки.
*   Функции должны быть объявлены до их вызова.
*   Функции должны иметь тип данных для возврата - если ничего не возвращается, используйте `void` .
*   Функции принимают параметры для работы, если они ничего не принимают, используйте `void` .
*   `return` завершает функцию и возвращает значение. У вас может быть несколько функций, но как только вы нажмете один, функция закончится там.
*   Когда вы передаете переменную функции, у нее есть своя копия для использования - изменение чего-либо в функции не изменяет ее вне функции.
*   Переменные, объявленные внутри функции, видны только внутри этой функции, если только они не объявлены статическими.