---
title: Logical Operators and If Statements
localeTitle: Логические операторы и утверждения
---
# Если заявления в C

Способность изменять поведение части кода, которая основана на определенной информации в среде, называется условным потоком кода. Иногда вы хотите, чтобы ваш код работал в соответствии с определенными условиями. В такой ситуации мы можем использовать операторы If. Он также известен как утверждение принятия решения, поскольку он принимает решение на основе данного выражения (или при заданном условии). Если выражение оценивается как true, тогда будет выполняться блок кода внутри оператора «if». Если выражение оценивается как false, тогда будет выполнен первый набор кода после окончания оператора «if» (после закрытия фигурной скобки). Выражение - это выражение, которое имеет реляционные и / или логические операторы, работающие с булевыми переменными , Выражение оценивается как true, так и false.

## Синтаксис _оператора if_
```
if (testExpression) { 
   // statements 
 } 
```

## Простой пример

Давайте посмотрим на пример этого в действии:

```C
#include <stdio.h> 
 #include <stdbool.h> 
 
 int main(void) { 
    if(true) { 
        printf("Statement is True!\n"); 
    } 
 
    return 0; 
 } 
```

```
output: 
 Statement is True! 
```

Как и helloworld.c, включен stdio.h. Новым в этой программе является stdbool.h, которая является стандартной булевой библиотекой - она ​​содержит код, который дает нам доступ к «true» и «false».

Кроме того, новый в приведенном выше примере - это оператор «if». Если оператор в скобках верен, код в скобках оператора if будет запущен. В случае этого примера верно true, поэтому код запускает функцию `printf` .

## Если еще

В инструкции «If-else»: если оператор в скобках верен, код в скобках оператора «if» будет выполнен, и если оператор в скобках является ложным, код в скобках « else 'будет выполнен.

Конечно, этот пример был не очень полезен, потому что истина всегда верна. Вот еще один пример:

```C
#include <stdio.h> 
 
 int main(void) { 
    int n = 2; 
 
    if(n == 3) { // comparing n with 3 
        printf("Statement is True!\n"); 
    } 
    else { // if first condition is not true, then comes to this block of code. 
        printf("Statement is False!\n"); 
    } 
 
    return 0; 
 } 
```

```
output: 
 Statement is False! 
```

Здесь есть несколько важных вещей. Во-первых, `stdbool.h` не был включен. Это нормально, потому что `true` и `false` не используются. В C мы имеем утверждения, которые рассматриваются как истинные и ложные, даже если слова true или false не участвуют в операции.

В скобках оператора if тоже есть что-то новое: `n == 3` . Это сравнение между `n` и числом 3. `==` является оператором сравнения и является одной из нескольких операций сравнения в C.

## Вложенное if-else

Операция if-else позволяет сделать выбор между двумя возможными альтернативами. Иногда нужно выбирать между более чем двумя возможностями. Например, функция знака в математике возвращает -1, если аргумент меньше нуля, возвращает +1, если аргумент больше нуля и возвращает ноль, если аргумент равен нулю. Следующий оператор C ++ реализует эту функцию:

```C
if (x < 0) 
   sign = -1; 
 else 
   if (x == 0) 
      sign = 0; 
   else 
      sign = 1; 
```

Это оператор if-else, в котором оператор, следующий за else, сам является инструкцией if-else. Если x меньше нуля, тогда знак устанавливается равным -1, однако, если он не меньше нуля, выполняется оператор, следующий за else. В этом случае, если x равно нулю, знак устанавливается равным нулю, а в противном случае он равен 1. Начинающие программисты часто используют последовательность операторов if вместо использования вложенного оператора if-else. То есть они пишут выше в логически эквивалентной форме:

```C
if (x < 0) 
   sign = -1; 
 if (x == 0) 
   sign = 0; 
 if (x > 0) 
   sign = 1; 
```

Эта версия не рекомендуется, так как она не дает понять, что только одно из операторов присваивания будет выполнено для заданного значения x. Также он неэффективен, поскольку все три условия всегда проверяются.

## Операторы сравнения

Имя оператора | Использование | Результат оператора ---------------------------- |: ---------: | --------- -------- Равенство | a == b | Истинно, если a равно b, false в противном случае Не равный | a! = b | Истинно, если a не равно b, false в противном случае Больше, чем | a> b | Истинно, если a больше b, false в противном случае Больше или равно | a> = b | Истинно, если a больше или равно b, false в противном случае Меньше, чем | a <b | Истинно, если a меньше b, false в противном случае Меньше или равно | a <= b | Истинно, если a меньше или равно b, false в противном случае

В этом примере также есть новое слово: `else` . Код внутри блока `else` выполняется только в том случае, если код внутри `if` не работает.

Мы можем многое сделать со всеми этими операторами! Рассмотрим следующее, где мы будем использовать инструкцию if-else:

```C
#include <stdio.h> 
 
 int main(void) { 
    int n = 5; 
 
    if(n == 5) { 
        printf("n is equal to 5!\n"); 
    } 
    else if (n > 5) { 
        printf("n is greater than 5!\n"); 
    } 
 
    return 0; 
 } 
```

```
output: 
 n is equal to 5! 
```

Оператор if-else имеет прикрепленное к нему «else if». Этот код запускается, если условие в предыдущем, если было ложным, но добавляет условие в свою собственную скобку, которое должно быть истинным до запуска кода.

## Логические операторы

Конечно, мы могли бы хотеть, чтобы что-то произошло, если это не так, или если это и что-то еще истинное. Для этого у нас есть логические операторы:! для not, && для и, и || для или. Давайте посмотрим на это в действии:

```C
#include <stfio.h> 
 
 int main(void) { 
    int n = 5; 
    int m = 10; 
 
    if(n > m || n == 15) { 
        printf("Either n is greater than m, or n is equal to 15\n"); 
    } 
    else if( n == 5 && m == 10 ) { 
        printf("n is equal to 5 and m is equal to 10!\n"); 
    } 
    else if ( !(n == 6)) { 
        printf("It is not true that n is equal to 6!\n"); 
    } 
    else if (n > 5) { 
        printf("n is greater than 5!\n"); 
    } 
 
    return 0; 
 } 
```

```
output: 
 n is equal to 5 and m is equal to 10! 
```

Вот первый набор скобок: `n > m || n == 5` . Это будет верно, если n больше m или n равно 5. n не больше m, но n равно 5. Поскольку одна из этих вещей истинна, и к ним присоединяется a или, это утверждение будет истинным, и код внутри будет напечатан.

Поскольку предыдущий код был выполнен, он не будет проверять другие утверждения else - они только проверяются, если предыдущие не проверяются. Однако, ради упражнения, рассмотрите, что будет проверять остальная часть кода. `n == 5 && m == 10` будет истинным, если n равно 5, а m равно 10. Это верно, но если n равно 6, оно больше не будет истинным, а код внутри этого еще не будет запущен ,

`!(n == 6)` использует скобки, чтобы сделать операцию более очевидной. Как и в математике, скобки могут использоваться для порядка операций: вещи в круглой скобке будут выполняться перед вещами, которые не находятся в круглых скобках. Таким образом, в этом случае `n == 6` будет оценен и будет ложным. `!` , 'not', переводит это значение с false на true, поэтому эта операция возвращает true. Однако, как и раньше, он не будет работать только потому, что одно из предыдущих утверждений было правдой, что это приложение уже было выполнено.

Наконец, делает ли `n > 5` значение true? Ответ - нет, потому что n _равно_ 5, поэтому оно не больше 5. В результате этот код не будет оцениваться как true. Чтобы это оценивалось как истина, следует использовать оператор `>=` .

## Деталь о сравнении C

Раньше вы читали, что сравнения проверяют, что что-то истинно или ложно, но это действительно только половина истины. Помните, что C - это свет и близок к аппаратным средствам, легко проверить, есть ли что-то 0, и что-то еще требует больше работы. Из-за этого то, что действительно делают сравнения, это проверка того, что что-то ложно, которому присваивается значение 0 или проверка, не является ли он ложным (любое другое значение).

В результате этот оператор if истинен и действителен:

```C
if(12452) { 
    printf("This is true!\n") 
 } 
```

По дизайну 0 является ложным, и по соглашению 1 истинно. Фактически, посмотрите на библиотеку `stdbool.h` описанную ранее:

```C
#define false   0 
 #define true    1 
```

На самом деле это немного больше, но это та часть, которая выполняет всю работу.

Эти две строки кода говорят компилятору, что слово «false» должно быть заменено на «0», а слово «true» должно быть заменено на «1». `stdbool.h` также есть некоторые инструкции для документации и компилятора, которые будут обсуждаться позже, но эти две строки действительно существуют.

# Секреты и уловки

Рассмотрим следующий код:

```C
#include <stdio.h> 
 
 int main() { 
    int i=3; 
 
    if(i=4) { 
      printf("This block is executed"); 
    } 
    else { 
      printf("NO! I am boss"); 
    } 
 } 
```

Каким будет выход? «НЕТ! Я босс»? если вы угадываете этот результат, вы ошибаетесь. Почему это случилось? потому что в выражении if вы использовали «=» вместо оператора «==». «==» - это компаратор.

Он будет сравнивать между двумя переменными, но «=» - оператор присваивания когда мы сказали i = 4, мы просто присваиваем значение 4 целому числу i, а так как в «C» каждое значение NON-ZERO истинно, if (i = 4) - истинное утверждение, и инструкции по этому исполнению будут выполнены

# Прежде чем продолжить ...

## Обзор

*   Операторы 'if' проверяют, истинно ли выражение, затем он запускает код в фигурных скобках.
*   «else» может быть добавлено в конец «if» и будет работать только в том случае, если предыдущий if (s) был ложным.
*   «else if» также может быть добавлен в конец «if» и будет выполняться только в том случае, если предыдущий оператор if (s) был ложным.
*   Все в компьютере представлено числами, поэтому каждое сравнение в C может быть выполнено путем обработки таких значений, как числа - даже истинные, ложные и символы.
*   Существует множество операторов сравнения:
*   \== равно
*   ! = не равно
*   \> больше, чем
*   <меньше
*   \> = меньше или равно
*   <= меньше или равно
*   У нас также есть некоторые логические операторы, которые позволяют нам объединять логические операции:
*   ! называется NOT operator - он меняет состояние операнда
*   && называется оператором AND. Он возвращает true, когда оба условия истинны
*   || называется оператором OR. Он возвращает true, когда по крайней мере одно из условий истинно