---
title: C
localeTitle: С
---
# Привет, мир! - Ваша первая программа C

## Получение максимальной отдачи от курса

Перед тем, как двигаться дальше, убедитесь, что вы довольны всеми концепциями в этой части руководства. Получение вашей первой программы важно, потому что она позволит вам следовать вместе с примерами, что еще одна хорошая вещь - практика делает совершенным! Понятия, которые могут ввести в заблуждение, будут содержать аннотацию, связанную с приложением. Если вы не понимаете концепцию, убедитесь, что вы обратитесь к приложению за дополнительной информацией.

## Цель курса

Цели этого курса - научить язык C начинающим. В идеале, кто-то, кто никогда не касался компьютерного языка, не сможет узнать C, следуя этим руководствам. Тем не менее, они по-прежнему будут полезны для более опытных программистов, включив резюме в конце каждой статьи. Хотя содержание, которое здесь описано, можно передавать на микроконтроллеры, такие как Arduino, это не является предметом настоящего руководства.

## Что такое C?

C - язык программирования общего назначения, изобретенный Деннисом Ричи в период с 1969 по 1973 год в Bell Labs. С тех пор он используется для создания таких вещей, как ядро ​​Linux, которое позволяет программному обеспечению взаимодействовать с оборудованием в операционных системах на базе Linux. Он может сделать это и другие операции низкого уровня, потому что он был разработан так, чтобы быть очень близким к машинным кодам, будучи все еще доступным для человека. Из-за этого он обеспечивает прямой доступ к компьютерной памяти и аппаратным средствам. Это делает его очень полезным в аппаратных и робототехнических приложениях, где быстрый доступ к этим функциям очень важен. C, как и другие языки низкого уровня, требует компиляции. Процесс компиляции принимает код C, который может быть прочитан человеком и превращает его в код, который может быть прочитан и выполнен компьютером. Компиляция требует компилятора, который может использоваться из командной строки или может использоваться в среде IDE.

Если вы предпочитаете использовать командную строку, рассмотрите `gcc` . Его можно найти по умолчанию в GNU + Linux операционных системах и на Mac, и легко попасть в Windows. Однако для новичков может быть более комфортной IDE. Рассмотрим CodeBlocks или Xcode, если вы заинтересованы в возможности писать и запускать код из графического интерфейса.

Теперь, когда у вас есть этот фон, давайте начнем с нашей программы «Hello, World». «Hello, World» - это традиционный способ начать работу с языка: он показывает, что мы можем писать код и запускать его, поэтому это хорошее место для начала!

## Привет мир в C

```C
#include <stdio.h> 
 
 int main(void) 
 { 
    printf("hello, world\n"); 
    return 0; 
 } 
```

Давайте разложим эту программу поэтапно.

Сначала находится `#include` :

```C
#include <stdio.h> // This is called preprocessor directives 
```

Это инструкция для компилятора, чтобы найти и включить набор файлов заголовков. Заголовочные файлы содержат дополнительный код, который мы можем использовать. В этом случае компилятору было предложено включить `<stdio.h>` , который содержит все полезные функции, такие как `printf()` . Мы также можем записать его как `#include"stdio.h"` . Мы подробно рассмотрим, какие функции будут позже, но пока просто помните, что функция представляет собой набор кода, который мы можем использовать.

```C
int main(void) 
 { 
 } 
```

Этот код объявляет основную функцию. Основная функция - специальная - она ​​всегда будет вызываться и всегда является «основной» частью вашей программы. Если это не в вашей программе, ваша программа не может работать и не будет компилироваться.

Запуск объявления функции с помощью `int` означает, что эта функция даст значение `int` когда оно будет выполняться через его код, - это выход этой функции. `int` - это тип данных «integer», а целые числа - целые числа, такие как -3, 0 или 18. Таким образом, мы знаем, что этот код будет работать, и когда это будет сделано, оно вернет нам целое число. По соглашению это целое число равно 0.

Далее `main` . `main` - это имя этой функции, и, как вы узнали ранее, важно иметь `main` функцию, потому что ваша программа не будет работать без нее. `main` следует `(void)` . Это говорит компилятору, что эта функция не принимает никаких параметров, что означает, что у нее нет ввода.

Это может не иметь большого смысла прямо сейчас, но вы узнаете больше об этом, когда начнете читать о функциях в C позже. На данный момент просто помните, что для вашей программы C требуется `main` функция, она не принимает никаких данных, и она дает номер в качестве вывода.

Наконец, есть скобки: `{` и `}` . Они отмечают начало и конец функции. Открытая фигурная скобка ( `{` ) знаменует начало, а закрывающая фигурная скобка ( `}` ) обозначает конец. Все между ними находится внутри функции.

Теперь давайте посмотрим на мясо программы:

```C
    printf("Hello, World!\n"); 
```

`printf` - это функция, которая берет текст и выводит его на экран. В скобках указывается, какую информацию мы хотим получить для `printf` и распечатать на экране. Мы показываем, что это строка, которую мы хотим напечатать, окружив ее в кавычки «вот так».

Обратите внимание, что \\ n найдено в кавычках - это говорит `printf` распечатать новую строку. Новая строка - это то, что печатается при нажатии на клавиатуре. Без явного указания C для печати новой строки все будет напечатано в той же строке.

Наконец, выражение printf () завершается точкой с запятой ( `;` ). Это показывает, что эта строка кода завершена. Без этого компилятор не знает, где заканчивается одна строка, а другая начинается, поэтому важно включить.

Программа заканчивается оператором return:

```C
return 0; 
```

Это показывает, что функция завершена и что она должна заканчиваться значением 0 для того, что запустило ее. Когда вы запускаете код на своем компьютере, это хорошо, потому что он позволяет другим программам лучше взаимодействовать с вашими.

Как и раньше, эта строка заканчивается точкой с запятой, чтобы указать, что линия завершена.

## Компиляция и запуск

Вы можете сохранить свой мировой файл hello так, как хотите, но ему нужно завершить расширение файла .c. В этом примере файл был назван «helloworld.c», потому что это ясное имя с расширением .c.

Существует много способов скомпилировать и запустить код C на вашем компьютере. Вот несколько:

#### Компиляция и запуск из командной строки с помощью GCC

Если вы используете Mac или GNU + Linux, у вас уже установлен GCC.

Чтобы запустить вашу программу на C, ее необходимо скомпилировать. Чтобы скомпилировать из командной строки с помощью gcc, выполните следующую команду с вашего терминала:

```shell
gcc -o helloworld ./helloworld.c 
```

`gcc` - `gcc` Gnu C, и он скомпилирует файл C, который мы передаем, в программу, которую может запускать ваш компьютер.

`-o helloworld` сообщает GCC, что вы хотите, чтобы скомпилированный файл (выход gcc) был файлом под названием helloworld. Последняя часть команды указывает GCC, где можно скомпилировать файл C. Если вам неудобно перемещаться с командной строки, этот шаг будет сложным, но это нормально - его легко узнать и вернуться, или вы можете попробовать из IDE.

После того как вы его скомпилируете, выполните следующую команду:

```shell
./helloworld 
```

Если все пошло хорошо, вы должны увидеть `Hello, World!` печатается на экране.

#### Компиляция и запуск C с помощью CodeBlocks

[Кодовые блоки можно скачать здесь.](http://www.codeblocks.org/downloads/26) Создайте новую программу с `file` -> `new` -> `file` , выберите источник C / C ++, выберите C как ваш язык и затем скопируйте текст helloworld.c, который вы читаете ранее. Скомпилируйте и запустите код с помощью `Build` -> `Build and Run` .

#### Компиляция и запуск C с Xcode

[Xcode можно скачать здесь.](https://developer.apple.com/xcode/)

#### Компиляция и запуск C с Dev-C ++

[Dev-C ++ можно скачать здесь.](https://sourceforge.net/projects/orwelldevcpp/) Создайте новую программу с `file` -> `new` -> `Source File` , затем скопируйте текст helloworld.c, который вы читаете ранее, а затем сохраните файл с `file` -> `save As` as hello.c, а затем скомпилируйте и запустите код с помощью `Execute` -> `Compile & Run` .

# Прежде чем продолжить ...

## Обзор

*   C является языком языковых языков программирования.
*   C использовался для повторной реализации операционной системы Unix.
*   C полезен, потому что он маленький, быстрый и имеет доступ к низкоуровневым операциям. Из-за этого он широко используется в робототехнике, операционных системах и бытовой электронике, но не в таких вещах, как веб-страницы.
*   Программа AC имеет несколько критических частей:
*   Оператор include, который сообщает компилятору C, где можно найти дополнительный код, который будет использоваться в программе.
*   Основная функция, в которой код сначала выполняется и требуется для компиляции.
*   Вещи внутри этой основной функции, которая будет выполнена, включая оператор return, который закрывает программу и дает значение программе, которая ее вызвала.
*   C необходимо скомпилировать для запуска.
*   C может использоваться для доступа к конкретным аппаратным адресам и для выполнения пин-кода типа для соответствия требованиям внешнего интерфейса с низким спросом на системные ресурсы во время выполнения.