---
title: Macros in C
localeTitle: Макросы в C
---
## Макросы в C

Макрос представляет собой фрагмент кода с заданным именем. Когда имя используется, оно заменяется содержимым макроса.

#### Определение макросов

Ключевое слово `#define` используется для определения новых макросов. За ним следует имя и содержание. По соглашению имена макросов записываются в верхнем регистре.

```C
#define PI 3.14 
```

Если вы используете макрос таким образом:

```C
printf("Value of PI: %d", PI); 
```

То же самое, что и написать:

```C
printf("Value of PI: %d", 3.14); 
```

#### Типы макросов

Существует два типа макросов. `Object-like` , показанные выше, и макросы, `Function-like` .

#### Функциональные макросы

Функция-подобное использует одно и то же ключевое слово `#define` . Разница в том, что вы используете пару круглых скобок после имени функции.

```C
#define hello_world() printf("Hello World!") 
```

Итак, позвонив:

```C
hello_world() 
```

Ты получаешь:

```C
printf("Hello World!"); 
```

Вы также можете установить параметры:

```C
#define hello(X) printf("Hello " X "!") 
```

Теперь вызывается:

```C
hello("World"); 
```

Вы получаете равноценность:

```C
printf("Hello World!"); 
```

#### Дополнительная информация:

[Документация онлайн GCC: макросы](https://gcc.gnu.org/onlinedocs/cpp/Macros.html)

[Документация по GCC: объектно-ориентированные макросы](https://gcc.gnu.org/onlinedocs/cpp/Object-like-Macros.html#Object-like-Macros)

[Документация онлайн GCC: функциональные макросы](https://gcc.gnu.org/onlinedocs/cpp/Function-like-Macros.html#Function-like-Macros)