---
title: malloc
localeTitle: таНос
---
# malloc в C

malloc () - это библиотечная функция, которая позволяет C динамически выделять память из кучи. Куча - это область памяти, где что-то хранится.

malloc () является частью stdlib.h и для его использования вам необходимо использовать `#include <stdlib.h>` .

## Использование Malloc

malloc () выделяет память запрошенного размера и возвращает указатель на начало выделенного блока. Чтобы удерживать этот возвращенный указатель, мы должны создать переменную. Указатель должен быть того же типа, что и в инструкции malloc.  
Здесь мы сделаем указатель на скоро будущий массив ints

```C
int* arrayPtr; 
```

В отличие от других языков, C не знает тип данных, на который он выделяет память; это нужно сказать. К счастью, C имеет функцию, называемую `sizeof()` которую мы можем использовать.

```C
arrayPtr = (int *)malloc(10 * sizeof(int)); 
```

Этот оператор использовал malloc для выделения памяти для массива из 10 целых чисел. Поскольку размеры могут меняться между компьютерами, важно использовать функцию sizeof () для вычисления размера на текущем компьютере.

Любая память, выделенная во время выполнения программы, должна быть освобождена до закрытия программы. Чтобы `free` память, мы можем использовать функцию free ()

```C
free( arrayPtr ); 
```

Этот оператор освободит ранее выделенную память. C не поставляется с `garbage collector` как некоторые другие языки, такие как Java. В результате память, которая не была должным образом освобождена, будет продолжать выделяться после закрытия программы.

# Прежде чем продолжить ...

## Обзор

*   Malloc используется для динамического распределения памяти и полезен, когда вы не знаете объем памяти, необходимый во время компиляции.
*   Выделение памяти позволяет объектам существовать за пределами текущего блока.
*   C передает значение вместо ссылки. Использование malloc для назначения памяти, а затем передать указатель на другую функцию, более эффективно, чем функция, воссоздающая структуру.